

<?php
use App\Models\Setting;
?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 class="mb-4">فواتير الشركاء</h2>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>المعاملة</th>
                            <th>الشريك</th>
                            <th>المبلغ</th>
                            <th>النسبة</th>
                            <th>الحالة</th>
                            <th>التاريخ</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($invoice->id); ?></td>
                            <td><?php echo e($invoice->transaction->description ?? 'معاملة #' . $invoice->transaction_id); ?></td>
                            <td>
                                <?php if($invoice->partner): ?>
                                    <?php echo e($invoice->partner->name); ?>

                                <?php else: ?>
                                    <?php echo e($invoice->seller_name ?: 'نظام إدارة الشركاء'); ?>

                                <?php endif; ?>
                            </td>
                            <td><?php echo e(number_format($invoice->amount, 3)); ?> <?php echo e(Setting::get('currency', 'JOD')); ?></td>
                            <td><?php echo e(number_format($invoice->share_percentage, 2)); ?>%</td>
                            <td>
                                <span class="badge bg-<?php echo e($invoice->status === 'paid' ? 'success' : ($invoice->status === 'cancelled' ? 'danger' : 'warning')); ?>">
                                    <?php echo e($invoice->status === 'paid' ? 'مدفوعة' : ($invoice->status === 'cancelled' ? 'ملغاة' : 'معلقة')); ?>

                                </span>
                            </td>
                            <td><?php echo e($invoice->created_at->format('Y-m-d')); ?></td>
                            <td>
                                <div class="btn-group">
                                    <a href="<?php echo e(route('invoices.show', $invoice)); ?>" class="btn btn-sm btn-info">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <?php if($invoice->status === 'pending'): ?>
                                    <button type="button" class="btn btn-sm btn-success update-status" 
                                            data-id="<?php echo e($invoice->id); ?>" data-status="paid">
                                        <i class="bi bi-check-lg"></i>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-danger update-status" 
                                            data-id="<?php echo e($invoice->id); ?>" data-status="cancelled">
                                        <i class="bi bi-x-lg"></i>
                                    </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <?php echo e($invoices->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    $('.update-status').click(function() {
        const id = $(this).data('id');
        const status = $(this).data('status');
        
        Swal.fire({
            title: 'تأكيد التحديث',
            text: 'هل أنت متأكد من تحديث حالة الفاتورة؟',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'لا'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `/invoices/${id}/status`,
                    type: 'POST',
                    data: {
                        status: status,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function() {
                        location.reload();
                    }
                });
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\GitHub\partners_system\resources\views/invoices/index.blade.php ENDPATH**/ ?>