

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5>المعاملات المالية</h5>
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addTransactionModal">
            إضافة معاملة جديدة
        </button>
    </div>
    <div class="card-body">
        <table class="table">
            <thead>
                <tr>
                    <th>التاريخ</th>
                    <th>النوع</th>
                    <th>التصنيف</th>
                    <th>المبلغ</th>
                    <th>الوصف</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($transaction->transaction_date->format('Y-m-d')); ?></td>
                    <td><?php echo e($transaction->type == 'income' ? 'إيراد' : 'مصروف'); ?></td>
                    <td><?php echo e($transaction->category_name); ?></td>
                    <td><?php echo e(number_format($transaction->amount, 3, '.', ',')); ?> JOD</td>
                    <td><?php echo e($transaction->description); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal إضافة معاملة -->
<div class="modal fade" id="addTransactionModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">إضافة معاملة جديدة</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addTransactionForm">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">النوع <span class="text-danger">*</span></label>
                        <select class="form-select" name="type" id="transaction_type" required>
                            <option value="">اختر النوع</option>
                            <option value="income">إيراد</option>
                            <option value="expense">مصروف</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">التصنيف <span class="text-danger">*</span></label>
                        <select class="form-select" name="category" id="transaction_category" required>
                            <option value="">اختر التصنيف</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">المبلغ</label>
                        <input type="number" class="form-control" name="amount" min="0" step="0.01" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">التاريخ</label>
                        <input type="date" class="form-control" name="transaction_date" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">الوصف</label>
                        <textarea class="form-control" name="description"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // إضافة CSRF token لجميع طلبات AJAX
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // إضافة معاملة جديدة
    $('#addTransactionForm').on('submit', function(e) {
        e.preventDefault();
        $.post('<?php echo e(route("transactions.store")); ?>', $(this).serialize())
            .done(function(response) {
                $('#addTransactionModal').modal('hide');
                showAlert('success', response.message);
                setTimeout(() => location.reload(), 1500);
            })
            .fail(function(xhr) {
                let errorMessage = 'حدث خطأ ما';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                } else if (xhr.responseJSON && xhr.responseJSON.errors) {
                    errorMessage = Object.values(xhr.responseJSON.errors).flat().join('\n');
                }
                showAlert('error', errorMessage);
            });
    });

    // تعديل معاملة
    $('#editTransactionForm').on('submit', function(e) {
        e.preventDefault();
        const id = $('#edit_transaction_id').val();
        
        $.ajax({
            url: `/transactions/${id}`,
            method: 'PUT',
            data: $(this).serialize(),
            success: function(response) {
                $('#editTransactionModal').modal('hide');
                showAlert('success', response.message);
                setTimeout(() => location.reload(), 1500);
            },
            error: function(xhr) {
                // تحسين معالجة الأخطاء
                let errorMessage = 'حدث خطأ ما';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                } else if (xhr.responseJSON && xhr.responseJSON.errors) {
                    errorMessage = Object.values(xhr.responseJSON.errors).flat().join('\n');
                }
                showAlert('error', errorMessage);
            }
        });
    });

    // حذف معاملة
    window.deleteTransaction = function(id) {
        if (confirm('هل أنت متأكد من حذف هذه المعاملة؟')) {
            $.ajax({
                url: `/transactions/${id}`,
                method: 'DELETE',
                success: function(response) {
                    showAlert('success', response.message);
                    setTimeout(() => location.reload(), 1500);
                },
                error: function(xhr) {
                    // تحسين معالجة الأخطاء
                    let errorMessage = 'حدث خطأ ما';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }
                    showAlert('error', errorMessage);
                }
            });
        }
    };

    // دالة مساعدة لعرض التنبيهات
    function showAlert(type, message) {
        const alertDiv = $('<div>')
            .addClass(`alert alert-${type} alert-dismissible fade show`)
            .attr('role', 'alert')
            .html(`
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `);

        $('.container').prepend(alertDiv);
        
        setTimeout(() => {
            alertDiv.alert('close');
        }, 3000);
    }

    // تحديث التصنيفات حسب النوع
    $('#transaction_type').on('change', function() {
        const type = $(this).val();
        const categorySelect = $('#transaction_category');
        categorySelect.empty().append('<option value="">اختر التصنيف</option>');
        
        if (type) {
            const categories = type === 'income' ? <?php echo json_encode(App\Models\Transaction::INCOME_CATEGORIES, 15, 512) ?> : <?php echo json_encode(App\Models\Transaction::EXPENSE_CATEGORIES, 15, 512) ?>;
            
            Object.entries(categories).forEach(([value, category]) => {
                categorySelect.append(`
                    <option value="${value}">
                        <i class="${category.icon}"></i> ${category.name}
                    </option>
                `);
            });
        }
    });
});
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\DELL\Desktop\partners_system\resources\views/transactions/index.blade.php ENDPATH**/ ?>