

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="mb-0">إدارة المستخدمين</h4>
                </div>
                <div class="card-body">
                    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addUserModal">
                        إضافة مستخدم جديد
                    </button>

                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>الاسم</th>
                                    <th>البريد الإلكتروني</th>
                                    <th>الدور</th>
                                    <th>الشريك</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($user->name); ?></td>
                                    <td><?php echo e($user->email); ?></td>
                                    <td><?php echo e($user->roles->first()->display_name ?? ''); ?></td>
                                    <td><?php echo e($user->partner->name ?? ''); ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-info me-2" onclick="editUser(<?php echo e($user->id); ?>, '<?php echo e($user->name); ?>', '<?php echo e($user->email); ?>', '<?php echo e($user->roles->first()->name); ?>', '<?php echo e($user->partner_id ?? ''); ?>')">
                                            تعديل
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="deleteUser(<?php echo e($user->id); ?>)">
                                            حذف
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h4 class="mb-0">إدارة الأدوار والصلاحيات</h4>
        </div>
        <div class="card-body">
            <div class="row">
                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><?php echo e($role->display_name); ?></h5>
                        </div>
                        <div class="card-body">
                            <form id="roleForm<?php echo e($role->id); ?>" data-role-id="<?php echo e($role->id); ?>" class="role-permissions-form">
                                <div class="row">
                                    <?php $__currentLoopData = $permissions->chunk(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-6">
                                        <?php $__currentLoopData = $chunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-check mb-2">
                                            <input class="form-check-input" type="checkbox" 
                                                name="permissions[]" 
                                                value="<?php echo e($permission->name); ?>"
                                                id="perm<?php echo e($role->id); ?><?php echo e($permission->id); ?>"
                                                <?php echo e($role->hasPermission($permission->name) ? 'checked' : ''); ?>

                                                <?php echo e($role->name === 'admin' ? 'disabled' : ''); ?>>
                                            <label class="form-check-label" for="perm<?php echo e($role->id); ?><?php echo e($permission->id); ?>">
                                                <?php echo e($permission->display_name); ?>

                                            </label>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <?php if($role->name !== 'admin'): ?>
                                <button type="submit" class="btn btn-primary mt-3">حفظ التغييرات</button>
                                <?php endif; ?>
                            </form>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<!-- Modal إضافة مستخدم -->
<div class="modal fade" id="addUserModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">إضافة مستخدم جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addUserForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">الاسم</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">البريد الإلكتروني</label>
                        <input type="email" class="form-control" name="email" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">كلمة المرور</label>
                        <input type="password" class="form-control" name="password" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">الدور</label>
                        <select class="form-control" name="role" required>
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($role->name); ?>"><?php echo e($role->display_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">الشريك</label>
                        <select class="form-control" name="partner_id">
                            <option value="">بدون شريك</option>
                            <?php $__currentLoopData = $partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($partner->id); ?>"><?php echo e($partner->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- نضيف موديل تعديل المستخدم -->
<div class="modal fade" id="editUserModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تعديل المستخدم</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="editUserForm">
                <input type="hidden" name="user_id" id="edit_user_id">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">الاسم</label>
                        <input type="text" class="form-control" name="name" id="edit_name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">البريد الإلكتروني</label>
                        <input type="email" class="form-control" name="email" id="edit_email" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">كلمة المرور الجديدة</label>
                        <input type="password" class="form-control" name="password" placeholder="اتركها فارغة إذا لم ترد تغييرها">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">الدور</label>
                        <select class="form-control" name="role" id="edit_role" required>
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($role->name); ?>"><?php echo e($role->display_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">الشريك</label>
                        <select class="form-control" name="partner_id" id="edit_partner_id">
                            <option value="">بدون شريك</option>
                            <?php $__currentLoopData = $partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($partner->id); ?>"><?php echo e($partner->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // إضافة CSRF token لجميع طلبات AJAX
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // تحديث صلاحيات الدور
    $('.role-permissions-form').on('submit', function(e) {
        e.preventDefault();
        const roleId = $(this).data('role-id');
        const permissions = $(this).find('input[name="permissions[]"]:checked').map(function() {
            return $(this).val();
        }).get();

        $.ajax({
            url: `/settings/roles/${roleId}/permissions`,
            method: 'PUT',
            data: { permissions: permissions },
            success: function(response) {
                showAlert('success', response.message);
            },
            error: function(xhr) {
                showAlert('error', xhr.responseJSON?.message || 'حدث خطأ أثناء تحديث الصلاحيات');
            }
        });
    });

    // إضافة مستخدم جديد
    $('#addUserForm').on('submit', function(e) {
        e.preventDefault();
        $.post('<?php echo e(route("settings.storeUser")); ?>', $(this).serialize())
            .done(function(response) {
                $('#addUserModal').modal('hide');
                showAlert('success', response.message);
                setTimeout(() => location.reload(), 1500);
            })
            .fail(function(xhr) {
                showAlert('error', xhr.responseJSON?.message || 'حدث خطأ ما');
            });
    });

    // حذف مستخدم
    window.deleteUser = function(id) {
        if (confirm('هل أنت متأكد من حذف هذا المستخدم؟')) {
            $.ajax({
                url: `/settings/users/${id}`,
                type: 'DELETE',
                success: function(response) {
                    showAlert('success', response.message);
                    setTimeout(() => location.reload(), 1500);
                },
                error: function(xhr) {
                    showAlert('error', xhr.responseJSON?.message || 'حدث خطأ أثناء حذف المستخدم');
                }
            });
        }
    };

    // تعديل المستخدم
    window.editUser = function(id, name, email, role, partnerId) {
        $('#edit_user_id').val(id);
        $('#edit_name').val(name);
        $('#edit_email').val(email);
        $('#edit_role').val(role);
        $('#edit_partner_id').val(partnerId);
        $('#editUserModal').modal('show');
    };

    // معالجة نموذج تعديل المستخدم
    $('#editUserForm').on('submit', function(e) {
        e.preventDefault();
        const userId = $('#edit_user_id').val();
        
        $.ajax({
            url: `/settings/users/${userId}`,
            method: 'PUT',
            data: $(this).serialize(),
            success: function(response) {
                $('#editUserModal').modal('hide');
                showAlert('success', response.message);
                setTimeout(() => location.reload(), 1500);
            },
            error: function(xhr) {
                showAlert('error', xhr.responseJSON?.message || 'حدث خطأ أثناء تحديث المستخدم');
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\DELL\Desktop\partners_system\resources\views/settings/index.blade.php ENDPATH**/ ?>