<?php
    $incomeCategories = $categories['income'] ?? config('categories.income', []);
    $expenseCategories = $categories['expense'] ?? config('categories.expense', []);
?>

<div class="card">
    <div class="card-header">
        <h5>إدارة التصنيفات</h5>
    </div>
    <div class="card-body">
        <ul class="nav nav-tabs" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" data-bs-toggle="tab" href="#income-categories">تصنيفات الإيرادات</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#expense-categories">تصنيفات المصروفات</a>
            </li>
        </ul>

        <div class="tab-content mt-3">
            <div id="income-categories" class="tab-pane active">
                <div class="mb-3">
                    <button type="button" class="btn btn-primary btn-sm" onclick="addCategory('income')">
                        إضافة تصنيف جديد
                    </button>
                </div>
                <div id="income-categories-list">
                    <?php $__currentLoopData = $incomeCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="category-item mb-2">
                            <div class="input-group">
                                <input type="text" class="form-control" name="income_categories[<?php echo e($key); ?>][name]" 
                                    value="<?php echo e($category['name']); ?>" placeholder="اسم التصنيف">
                                <input type="text" class="form-control" name="income_categories[<?php echo e($key); ?>][icon]" 
                                    value="<?php echo e($category['icon']); ?>" placeholder="الأيقونة">
                                <input type="color" class="form-control form-control-color" 
                                    name="income_categories[<?php echo e($key); ?>][color]" value="<?php echo e($category['color']); ?>">
                                <button type="button" class="btn btn-danger" onclick="removeCategory(this)">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <div id="expense-categories" class="tab-pane">
                <div class="mb-3">
                    <button type="button" class="btn btn-primary btn-sm" onclick="addCategory('expense')">
                        إضافة تصنيف جديد
                    </button>
                </div>
                <div id="expense-categories-list">
                    <?php $__currentLoopData = $expenseCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="category-item mb-2">
                            <div class="input-group">
                                <input type="text" class="form-control" name="expense_categories[<?php echo e($key); ?>][name]" 
                                    value="<?php echo e($category['name']); ?>" placeholder="اسم التصنيف">
                                <input type="text" class="form-control" name="expense_categories[<?php echo e($key); ?>][icon]" 
                                    value="<?php echo e($category['icon']); ?>" placeholder="الأيقونة">
                                <input type="color" class="form-control form-control-color" 
                                    name="expense_categories[<?php echo e($key); ?>][color]" value="<?php echo e($category['color']); ?>">
                                <button type="button" class="btn btn-danger" onclick="removeCategory(this)">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <div class="mt-3">
            <button type="button" class="btn btn-primary" onclick="saveCategories()">حفظ التصنيفات</button>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function addCategory(type) {
    const list = document.getElementById(`${type}-categories-list`);
    const newItem = document.createElement('div');
    newItem.className = 'category-item mb-2';
    newItem.innerHTML = `
        <div class="input-group">
            <input type="text" class="form-control" name="${type}_categories[][name]" placeholder="اسم التصنيف">
            <input type="text" class="form-control" name="${type}_categories[][icon]" placeholder="الأيقونة">
            <input type="color" class="form-control form-control-color" name="${type}_categories[][color]" value="#000000">
            <button type="button" class="btn btn-danger" onclick="removeCategory(this)">
                <i class="bi bi-trash"></i>
            </button>
        </div>
    `;
    list.appendChild(newItem);
}

function removeCategory(button) {
    button.closest('.category-item').remove();
}

function saveCategories() {
    const formData = {
        income_categories: [],
        expense_categories: []
    };

    // جمع بيانات تصنيفات الإيرادات
    document.querySelectorAll('#income-categories-list .category-item').forEach(item => {
        formData.income_categories.push({
            name: item.querySelector('input[name$="[name]"]').value,
            icon: item.querySelector('input[name$="[icon]"]').value,
            color: item.querySelector('input[name$="[color]"]').value
        });
    });

    // جمع بيانات تصنيفات المصروفات
    document.querySelectorAll('#expense-categories-list .category-item').forEach(item => {
        formData.expense_categories.push({
            name: item.querySelector('input[name$="[name]"]').value,
            icon: item.querySelector('input[name$="[icon]"]').value,
            color: item.querySelector('input[name$="[color]"]').value
        });
    });

    // إرسال البيانات
    fetch('<?php echo e(route("settings.categories.update")); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: JSON.stringify(formData)
    })
    .then(response => response.json())
    .then(data => {
        showAlert('success', data.message);
    })
    .catch(error => {
        showAlert('error', 'حدث خطأ أثناء حفظ التصنيفات');
    });
}
</script>
<?php $__env->stopPush(); ?><?php /**PATH D:\GitHub\partners_system\resources\views/settings/partials/categories.blade.php ENDPATH**/ ?>