

<?php $__env->startSection('content'); ?>
<div class="card mb-4">
    <div class="card-header">
        <h5>ملخص الأرباح والخسائر</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-4">
                <div class="card bg-success text-white">
                    <div class="card-body">
                        <h6>إجمالي الإيرادات</h6>
                        <h3><?php echo e(number_format($totalIncome, 3)); ?> JOD</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-danger text-white">
                    <div class="card-body">
                        <h6>إجمالي المصروفات</h6>
                        <h3><?php echo e(number_format($totalExpense, 3)); ?> JOD</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card <?php echo e($netProfit >= 0 ? 'bg-primary' : 'bg-danger'); ?> text-white">
                    <div class="card-body">
                        <h6>صافي الربح</h6>
                        <h3><?php echo e(number_format($netProfit, 3)); ?> JOD</h3>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card mt-4">
    <div class="card-header">
        <h5 class="mb-0">
            <?php if($isPartner): ?>
                حصتي من الأرباح
            <?php else: ?>
                حصص الشركاء
            <?php endif; ?>
        </h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered partners-table">
                <thead>
                    <tr>
                        <th>الشريك</th>
                        <th>النسبة الأصلية</th>
                        <th>النسبة الفعلية</th>
                        <th>الحصة</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $partnerShares; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $share): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($share['name']); ?></td>
                        <td><?php echo e(number_format($share['percentage'], 2)); ?>%</td>
                        <td><?php echo e(number_format($share['adjusted_percentage'], 2)); ?>%</td>
                        <td><?php echo e(number_format($share['share'], 3)); ?> JOD</td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr class="table-secondary">
                        <th>المجموع</th>
                        <th><?php echo e(number_format($totalPercentage, 2)); ?>%</th>
                        <th>100.00%</th>
                        <th><?php echo e(number_format($netProfit, 3)); ?> JOD</th>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="card mt-4">
    <div class="card-header">
        <h5>تصفية التقارير</h5>
    </div>
    <div class="card-body">
        <form id="filterForm">
            <?php echo csrf_field(); ?>
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">من تاريخ</label>
                    <input type="date" class="form-control" name="from_date">
                </div>
                <div class="col-md-3">
                    <label class="form-label">إلى تاريخ</label>
                    <input type="date" class="form-control" name="to_date">
                </div>
                <div class="col-md-3">
                    <label class="form-label">النوع</label>
                    <select class="form-select" name="type">
                        <option value="">الكل</option>
                        <option value="income">إيراد</option>
                        <option value="expense">مصروف</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary d-block">تصفية</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card mt-4">
    <div class="card-header">
        <h5>المعاملات</h5>
    </div>
    <div class="card-body">
        <?php echo $__env->make('reports.partials.transactions-table', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // إضافة CSRF token لجميع طلبات AJAX
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // تحديث الجدول والإحصائيات
    function updateData(response) {
        if (response.transactions) {
            const tbody = $('.transactions-table tbody');
            tbody.empty();

            const categories = {
                income: <?php echo json_encode(App\Models\Transaction::INCOME_CATEGORIES, 15, 512) ?>,
                expense: <?php echo json_encode(App\Models\Transaction::EXPENSE_CATEGORIES, 15, 512) ?>
            };

            const isAdmin = <?php echo e(auth()->user()->hasRole('admin') ? 'true' : 'false'); ?>;

            response.transactions.forEach(function(transaction) {
                // تنسيق التاريخ
                const date = new Date(transaction.transaction_date);
                const formattedDate = date.toISOString().split('T')[0];
                
                // الحصول على معلومات التصنيف
                const category = categories[transaction.type]?.[transaction.category] || {
                    name: transaction.category,
                    icon: 'fas fa-circle',
                    color: 'secondary'
                };

                let html = `
                    <tr>
                        <td>${formattedDate}</td>
                        <td>
                            <span class="badge bg-${transaction.type === 'income' ? 'success' : 'danger'}">
                                ${transaction.type === 'income' ? 'إيراد' : 'مصروف'}
                            </span>
                        </td>
                        <td>
                            <i class="${category.icon} text-${category.color}"></i>
                            ${category.name}
                        </td>
                        <td>${Number(transaction.amount).toFixed(3)} JOD</td>
                        <td>${transaction.description || '-'}</td>`;

                if (isAdmin) {
                    html += `<td>${transaction.partner?.name || '-'}</td>`;
                }

                html += '</tr>';
                tbody.append(html);
            });
        }

        if (response.stats) {
            $('#totalIncome').text(Number(response.stats.total_income).toFixed(3) + ' JOD');
            $('#totalExpense').text(Number(response.stats.total_expense).toFixed(3) + ' JOD');
            $('#netProfit').text(Number(response.stats.net_profit).toFixed(3) + ' JOD');
        }

        if (response.partnerShares) {
            const tbody = $('.partners-table tbody');
            tbody.empty();

            // إضافة صف المجموع
            let totalShare = 0;

            response.partnerShares.forEach(function(share) {
                const shareAmount = Number(share.share);
                totalShare += shareAmount;
                
                tbody.append(`
                    <tr>
                        <td>${share.name}</td>
                        <td>${Number(share.percentage).toFixed(2)}%</td>
                        <td>${Number(share.adjusted_percentage).toFixed(2)}%</td>
                        <td>${shareAmount.toFixed(3)} JOD</td>
                    </tr>
                `);
            });

            // إضافة صف المجموع فقط للمدير
            if (!response.isPartner) {
                tbody.append(`
                    <tr class="table-secondary">
                        <th>المجموع</th>
                        <th>${Number(response.totalPercentage).toFixed(2)}%</th>
                        <th>100.00%</th>
                        <th>${totalShare.toFixed(3)} JOD</th>
                    </tr>
                `);
            }
        }
    }

    // تصفية التقارير
    $('#filterForm').on('submit', function(e) {
        e.preventDefault();
        
        const submitBtn = $(this).find('button[type="submit"]');
        submitBtn.prop('disabled', true);

        $.ajax({
            url: '<?php echo e(route("reports.filter")); ?>',
            method: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                if (response.success) {
                    updateData(response);
                } else {
                    showAlert('error', response.message || 'حدث خطأ في تصفية البيانات');
                }
            },
            error: function(xhr) {
                let errorMessage = 'حدث خطأ في تصفية البيانات';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                }
                showAlert('error', errorMessage);
            },
            complete: function() {
                submitBtn.prop('disabled', false);
            }
        });
    });

    // دالة مساعدة لعرض التنبيهات
    function showAlert(type, message) {
        const alertDiv = $('<div>')
            .addClass(`alert alert-${type} alert-dismissible fade show`)
            .attr('role', 'alert')
            .html(`
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `);

        $('.card-body').prepend(alertDiv);
        
        setTimeout(() => {
            alertDiv.alert('close');
        }, 3000);
    }
});
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\DELL\Desktop\partners_system\resources\views/reports/index.blade.php ENDPATH**/ ?>