

<?php
use App\Models\Setting;
?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row">
        <!-- القائمة الجانبية -->
        <div class="col-md-3">
            <div class="list-group">
                <a href="#general-settings" class="list-group-item list-group-item-action active" data-bs-toggle="list">
                    الإعدادات العامة
                </a>
                <a href="#categories" class="list-group-item list-group-item-action" data-bs-toggle="list">
                    إدارة التصنيفات
                </a>
                <a href="#users" class="list-group-item list-group-item-action" data-bs-toggle="list">
                    إدارة المستخدمين
                </a>
                <a href="#roles" class="list-group-item list-group-item-action" data-bs-toggle="list">
                    الأدوار والصلاحيات
                </a>
            </div>
        </div>

        <!-- المحتوى -->
        <div class="col-md-9">
            <div class="tab-content">
                <div class="tab-pane fade show active" id="general-settings">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5>إعدادات النظام</h5>
                        </div>
                        <div class="card-body">
                            <form id="systemSettingsForm">
                                <?php echo csrf_field(); ?>
                                <div class="mb-3">
                                    <label class="form-label">نظام الفواتير</label>
                                    <select class="form-select" name="invoice_system">
                                        <option value="split" <?php echo e(Setting::get('invoice_system', 'split') === 'split' ? 'selected' : ''); ?>>
                                            تقسيم الفواتير على الشركاء
                                        </option>
                                        <option value="single" <?php echo e(Setting::get('invoice_system', 'split') === 'single' ? 'selected' : ''); ?>>
                                            فاتورة واحدة باسم النظام
                                        </option>
                                    </select>
                                    <small class="text-muted">
                                        في حالة اختيار "فاتورة واحدة"، سيتم إصدار فاتورة واحدة بالمبلغ الكامل باسم النظام
                                    </small>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">اسم النظام في الفواتير</label>
                                    <input type="text" class="form-control" name="system_name" 
                                           value="<?php echo e(Setting::get('system_name', 'نظام إدارة الشركاء')); ?>">
                                    <small class="text-muted">سيظهر هذا الاسم كاسم البائع في حالة اختيار نظام الفاتورة الواحدة</small>
                                </div>

                                <button type="submit" class="btn btn-primary">حفظ الإعدادات</button>
                            </form>
                        </div>
                    </div>

                    <div class="card mb-4">
                        <div class="card-header">
                            <h5>الإعدادات العامة</h5>
                        </div>
                        <div class="card-body">
                            <form id="generalSettingsForm">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">اسم الشركة</label>
                                        <input type="text" class="form-control" name="company_name" 
                                               value="<?php echo e(Setting::get('company_name', '')); ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">الرقم الضريبي</label>
                                        <input type="text" class="form-control" name="tax_number" 
                                               value="<?php echo e(Setting::get('tax_number', '')); ?>">
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">رقم الهاتف</label>
                                        <input type="text" class="form-control" name="phone" 
                                               value="<?php echo e(Setting::get('phone', '')); ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">البريد الإلكتروني</label>
                                        <input type="email" class="form-control" name="email" 
                                               value="<?php echo e(Setting::get('email', '')); ?>">
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">العنوان</label>
                                    <textarea class="form-control" name="address" rows="2"><?php echo e(Setting::get('address', '')); ?></textarea>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">العملة</label>
                                        <select class="form-select" name="currency">
                                            <option value="JOD" <?php echo e(Setting::get('currency') === 'JOD' ? 'selected' : ''); ?>>دينار أردني (JOD)</option>
                                            <option value="SAR" <?php echo e(Setting::get('currency') === 'SAR' ? 'selected' : ''); ?>>ريال سعودي (SAR)</option>
                                            <option value="USD" <?php echo e(Setting::get('currency') === 'USD' ? 'selected' : ''); ?>>دولار أمريكي (USD)</option>
                                            <option value="AED" <?php echo e(Setting::get('currency') === 'AED' ? 'selected' : ''); ?>>درهم إماراتي (AED)</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">نسبة الضريبة (%)</label>
                                        <input type="number" class="form-control" name="tax_rate" step="0.01"
                                               value="<?php echo e(Setting::get('tax_rate', '0')); ?>">
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">شعار الشركة</label>
                                        <input type="file" class="form-control" name="logo" accept="image/*">
                                        <?php if(Setting::get('logo')): ?>
                                            <div class="mt-2">
                                                <img src="<?php echo e(asset('storage/' . Setting::get('logo'))); ?>" 
                                                     alt="شعار الشركة" style="max-height: 50px">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">الختم الرسمي</label>
                                        <input type="file" class="form-control" name="stamp" accept="image/*">
                                        <?php if(Setting::get('stamp')): ?>
                                            <div class="mt-2">
                                                <img src="<?php echo e(asset('storage/' . Setting::get('stamp'))); ?>" 
                                                     alt="الختم الرسمي" style="max-height: 50px">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <button type="submit" class="btn btn-primary">حفظ الإعدادات</button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="categories">
                    <?php echo $__env->make('settings.partials.categories', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="tab-pane fade" id="users">
                    <?php echo $__env->make('settings.partials.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="tab-pane fade" id="roles">
                    <?php echo $__env->make('settings.partials.roles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // حفظ الإعدادات العامة
    $('#generalSettingsForm').on('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        
        $.ajax({
            url: '<?php echo e(route("settings.update")); ?>',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                showAlert('success', 'تم حفظ الإعدادات بنجاح');
            },
            error: function(xhr) {
                showAlert('error', 'حدث خطأ أثناء حفظ الإعدادات');
            }
        });
    });

    // حفظ إعدادات نظام الفواتير
    $('#systemSettingsForm').on('submit', function(e) {
        e.preventDefault();
        
        $.ajax({
            url: '<?php echo e(route("settings.update")); ?>',
            method: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                showAlert('success', 'تم حفظ إعدادات النظام بنجاح');
            },
            error: function(xhr) {
                showAlert('error', 'حدث خطأ أثناء حفظ الإعدادات');
            }
        });
    });

    function showAlert(type, message) {
        const alertDiv = $('<div>')
            .addClass(`alert alert-${type} alert-dismissible fade show`)
            .attr('role', 'alert')
            .html(`
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `);

        $('.container').prepend(alertDiv);
        
        setTimeout(() => {
            alertDiv.alert('close');
        }, 3000);
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\GitHub\partners_system\resources\views/settings/index.blade.php ENDPATH**/ ?>