<?php
use Illuminate\Support\Facades\Storage;
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>نظام إدارة الشركاء</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Tajawal', sans-serif;
            background: #f4f6f9;
        }

        /* Sidebar Styles */
        .sidebar {
            position: fixed;
            right: 0;
            top: 0;
            bottom: 0;
            width: 250px;
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
            z-index: 1000;
            transition: all 0.3s ease;
        }

        .sidebar-brand {
            padding: 1.5rem;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }

        .sidebar-brand img {
            width: 50px;
            height: 50px;
            margin-bottom: 1rem;
        }

        .sidebar-brand h4 {
            color: #fff;
            font-size: 1.2rem;
            margin: 0;
            font-weight: 500;
        }

        .nav-item {
            padding: 0.3rem 1rem;
        }

        .nav-link {
            display: flex;
            align-items: center;
            padding: 0.8rem 1rem;
            color: rgba(255,255,255,0.7);
            border-radius: 6px;
            transition: all 0.3s ease;
        }

        .nav-link:hover {
            color: #fff;
            background: rgba(255,255,255,0.1);
            transform: translateX(-5px);
        }

        .nav-link.active {
            color: #fff;
            background: rgba(255,255,255,0.2);
            box-shadow: 0 2px 6px rgba(0,0,0,0.2);
        }

        .nav-link i {
            font-size: 1.1rem;
            margin-left: 0.8rem;
            width: 20px;
            text-align: center;
        }

        .nav-divider {
            margin: 1rem;
            border-top: 1px solid rgba(255,255,255,0.1);
        }

        /* Main Content */
        .main-content {
            margin-right: 250px;
            padding: 2rem;
            transition: all 0.3s ease;
        }

        /* Header */
        .header {
            background: #fff;
            padding: 1rem 1.5rem;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 2rem;
        }

        /* Cards */
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            transition: transform 0.3s ease;
        }

        .card:hover {
            transform: translateY(-5px);
        }

        .card-header {
            background: #fff;
            border-bottom: 1px solid #eee;
            padding: 1rem 1.5rem;
            font-weight: 500;
        }

        /* Stats Cards */
        .stats-card {
            padding: 1.5rem;
            border-radius: 10px;
            color: #fff;
            transition: all 0.3s ease;
        }

        .stats-card.income {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        }

        .stats-card.expense {
            background: linear-gradient(135deg, #dc3545 0%, #f86384 100%);
        }

        .stats-card.profit {
            background: linear-gradient(135deg, #007bff 0%, #4facfe 100%);
        }

        /* Tables */
        .table {
            background: #fff;
            border-radius: 10px;
            overflow: hidden;
        }

        .table th {
            background: #f8f9fa;
            font-weight: 500;
            border-top: none;
        }

        /* Forms */
        .form-control {
            border-radius: 6px;
            border: 1px solid #e0e0e0;
            padding: 0.6rem 1rem;
        }

        .form-control:focus {
            border-color: #4facfe;
            box-shadow: 0 0 0 0.2rem rgba(79,172,254,0.25);
        }

        /* Buttons */
        .btn {
            border-radius: 6px;
            padding: 0.5rem 1.2rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-primary {
            background: linear-gradient(135deg, #007bff 0%, #4facfe 100%);
            border: none;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(79,172,254,0.3);
        }

        /* User Dropdown */
        .user-menu {
            background: #fff;
            border-radius: 6px;
            padding: 0.5rem 1rem;
            display: flex;
            align-items: center;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .user-menu:hover {
            background: #f8f9fa;
        }

        .user-menu img {
            width: 35px;
            height: 35px;
            border-radius: 50%;
            margin-left: 0.8rem;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(100%);
            }

            .sidebar.show {
                transform: translateX(0);
            }

            .main-content {
                margin-right: 0;
            }

            .toggle-sidebar {
                display: block !important;
            }
        }
    </style>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
</head>
<body>
    <!-- Sidebar -->
    <nav class="sidebar">
        <div class="sidebar-brand">
            <img src="<?php echo e(asset('images/logo.png')); ?>" alt="Logo">
            <h4>نظام إدارة الشركاء</h4>
        </div>

        <ul class="nav flex-column mt-3">
            
            <li class="nav-item">
                <a class="nav-link <?php echo e(request()->routeIs('partners.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('partners.index')); ?>">
                    <i class="bi bi-people-fill"></i>
                    <span>إدارة الشركاء</span>
                </a>
            </li>
          

            <div class="nav-divider"></div>

            
            <li class="nav-item">
                <a class="nav-link <?php echo e(request()->routeIs('transactions.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('transactions.index')); ?>">
                    <i class="bi bi-cash-stack"></i>
                    <span>المعاملات</span>
                </a>
            </li>
           

            
            <li class="nav-item">
                <a class="nav-link <?php echo e(request()->routeIs('reports.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('reports.index')); ?>">
                    <i class="bi bi-file-earmark-text"></i>
                    <span>التقارير</span>
                </a>
            </li>
          

            
            <li class="nav-item">
                <a class="nav-link <?php echo e(request()->routeIs('settings.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('settings.index')); ?>">
                    <i class="bi bi-gear-fill"></i>
                    <span>الإعدادات</span>
                </a>
            </li>
          
        </ul>
    </nav>

    <!-- Main Content -->
    <main class="main-content">
        <div class="header d-flex justify-content-between align-items-center">
            <button class="btn toggle-sidebar d-md-none">
                <i class="bi bi-list"></i>
            </button>
            <h4 class="mb-0"><?php echo $__env->yieldContent('title', 'لوحة التحكم'); ?></h4>
            <div class="user-menu" data-bs-toggle="dropdown">
                <img src="<?php echo e(auth()->user()->avatar ? Storage::url(auth()->user()->avatar) : asset('images/default-avatar.png')); ?>" 
                     alt="User Avatar" 
                     class="user-avatar">
                <span><?php echo e(auth()->user()->name); ?></span>
                <i class="bi bi-chevron-down ms-2"></i>
            </div>
            <div class="dropdown-menu">
                <a href="<?php echo e(route('profile.edit')); ?>" class="dropdown-item">
                    <i class="bi bi-person"></i>
                    الملف الشخصي
                </a>
                <form action="<?php echo e(route('logout')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="dropdown-item">
                        <i class="bi bi-box-arrow-right"></i>
                        تسجيل الخروج
                    </button>
                </form>
            </div>
        </div>

        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
    $(document).ready(function() {
        $('.toggle-sidebar').on('click', function() {
            $('.sidebar').toggleClass('show');
        });

        // Close sidebar when clicking outside on mobile
        $(document).on('click', function(e) {
            if ($(window).width() < 768) {
                if (!$(e.target).closest('.sidebar, .toggle-sidebar').length) {
                    $('.sidebar').removeClass('show');
                }
            }
        });
    });

    function showAlert(type, message) {
        const alertDiv = $('<div>')
            .addClass(`alert alert-${type} alert-dismissible fade show`)
            .attr('role', 'alert')
            .html(`
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `);

        $('.main-content').prepend(alertDiv);
        
        setTimeout(() => {
            alertDiv.alert('close');
        }, 3000);
    }
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html> <?php /**PATH C:\Users\DELL\Desktop\partners_system\resources\views/layouts/app.blade.php ENDPATH**/ ?>