<?php
use App\Models\Setting;
use Illuminate\Support\Facades\Storage;
?>

<div class="card">
    <div class="card-header">
        <h5>الإعدادات العامة</h5>
    </div>
    <div class="card-body">
        <form action="<?php echo e(route('settings.general.update')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            
            <div class="mb-3">
                <label class="form-label">اسم التطبيق</label>
                <input type="text" name="app_name" class="form-control" 
                    value="<?php echo e(Setting::get('app_name', config('app.name'))); ?>" required>
            </div>

            <div class="mb-3">
                <label class="form-label">الشعار</label>
                <?php if($logo = Setting::get('logo')): ?>
                    <div class="mb-2">
                        <img src="<?php echo e(Storage::url($logo)); ?>" alt="Logo" class="img-thumbnail" style="height: 50px">
                        <button type="button" class="btn btn-sm btn-danger" onclick="deleteLogo()">
                            <i class="bi bi-trash"></i>
                        </button>
                    </div>
                <?php endif; ?>
                <input type="file" name="logo" class="form-control" accept="image/*">
            </div>

            <div class="mb-3">
                <label class="form-label">الأيقونة المفضلة</label>
                <?php if($favicon = Setting::get('favicon')): ?>
                    <div class="mb-2">
                        <img src="<?php echo e(Storage::url($favicon)); ?>" alt="Favicon" class="img-thumbnail" style="height: 32px">
                        <button type="button" class="btn btn-sm btn-danger" onclick="deleteFavicon()">
                            <i class="bi bi-trash"></i>
                        </button>
                    </div>
                <?php endif; ?>
                <input type="file" name="favicon" class="form-control" accept="image/x-icon,image/png">
            </div>

            <div class="mb-3">
                <label class="form-label">نص التذييل</label>
                <textarea name="footer_text" class="form-control" rows="2"><?php echo e(Setting::get('footer_text')); ?></textarea>
            </div>

            <div class="mb-3">
                <label class="form-label">العملة</label>
                <input type="text" name="currency" class="form-control" 
                    value="<?php echo e(Setting::get('currency', 'JOD')); ?>" required>
            </div>

            <div class="mb-3">
                <label class="form-label">المنطقة الزمنية</label>
                <select name="timezone" class="form-control" required>
                    <?php $__currentLoopData = timezone_identifiers_list(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($timezone); ?>" 
                            <?php echo e(Setting::get('timezone', config('app.timezone')) == $timezone ? 'selected' : ''); ?>>
                            <?php echo e($timezone); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <button type="submit" class="btn btn-primary">حفظ الإعدادات</button>
        </form>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function deleteLogo() {
    if (confirm('هل أنت متأكد من حذف الشعار؟')) {
        $.ajax({
            url: '<?php echo e(route("settings.logo.delete")); ?>',
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            success: function(response) {
                showAlert('success', response.message);
                setTimeout(() => location.reload(), 1500);
            },
            error: function(xhr) {
                showAlert('error', 'حدث خطأ أثناء حذف الشعار');
            }
        });
    }
}

function deleteFavicon() {
    if (confirm('هل أنت متأكد من حذف الأيقونة المفضلة؟')) {
        $.ajax({
            url: '<?php echo e(route("settings.favicon.delete")); ?>',
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            success: function(response) {
                showAlert('success', response.message);
                setTimeout(() => location.reload(), 1500);
            },
            error: function(xhr) {
                showAlert('error', 'حدث خطأ أثناء حذف الأيقونة المفضلة');
            }
        });
    }
}
</script>
<?php $__env->stopPush(); ?><?php /**PATH D:\partners_system\resources\views/settings/partials/general.blade.php ENDPATH**/ ?>