

<?php $__env->startSection('content'); ?>
<!-- ملخص الأرباح والخسائر -->
<div class="card mb-4 shadow-sm">
    <div class="card-header bg-white py-3">
        <h5 class="mb-0"><i class="bi bi-graph-up"></i> ملخص الأرباح والخسائر</h5>
    </div>
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-4">
                <div class="card bg-success bg-gradient h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-white-50 mb-2">إجمالي الإيرادات</h6>
                                <h3 class="text-white mb-0" id="total-income"><?php echo e(number_format($totalIncome, 3)); ?> JOD</h3>
                            </div>
                            <i class="bi bi-arrow-up-circle fs-1 text-white-50"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-danger bg-gradient h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-white-50 mb-2">إجمالي المصروفات</h6>
                                <h3 class="text-white mb-0" id="total-expense"><?php echo e(number_format($totalExpense, 3)); ?> JOD</h3>
                            </div>
                            <i class="bi bi-arrow-down-circle fs-1 text-white-50"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card <?php echo e($netProfit >= 0 ? 'bg-primary' : 'bg-danger'); ?> bg-gradient h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-white-50 mb-2">صافي الربح</h6>
                                <h3 class="text-white mb-0" id="net-profit"><?php echo e(number_format($netProfit, 3)); ?> JOD</h3>
                            </div>
                            <i class="bi bi-calculator fs-1 text-white-50"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- حصص الشركاء -->
<div class="card mb-4 shadow-sm">
    <div class="card-header bg-white py-3">
        <h5 class="mb-0">
            <i class="bi bi-pie-chart"></i>
            <?php if($isPartner): ?>
                حصتي من الأرباح
            <?php else: ?>
                حصص الشركاء
            <?php endif; ?>
        </h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-hover partners-table">
                <thead class="table-light">
                    <tr>
                        <th>الشريك</th>
                        <th>النسبة الأصلية</th>
                        <th>النسبة الفعلية</th>
                        <th>الحصة</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $partnerShares; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $share): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <i class="bi bi-person-circle me-1"></i>
                            <?php echo e($share['name']); ?>

                        </td>
                        <td><?php echo e(number_format($share['percentage'], 2)); ?>%</td>
                        <td><?php echo e(number_format($share['adjusted_percentage'], 2)); ?>%</td>
                        <td class="text-nowrap"><?php echo e(number_format($share['share'], 3)); ?> JOD</td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr class="table-secondary fw-bold">
                        <td>المجموع</td>
                        <td><?php echo e(number_format(array_sum(array_column($partnerShares, 'percentage')), 2)); ?>%</td>
                        <td>100.00%</td>
                        <td class="text-nowrap"><?php echo e(number_format(array_sum(array_column($partnerShares, 'share')), 3)); ?> JOD</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- فلتر التقارير -->
<div class="card mb-4 shadow-sm">
    <div class="card-header bg-white py-3">
        <h5 class="mb-0"><i class="bi bi-funnel"></i> تصفية التقارير</h5>
    </div>
    <div class="card-body">
        <form id="filterForm">
            <?php echo csrf_field(); ?>
            <div class="row g-3">
                <?php if(auth()->user()->hasRole(['admin', 'accountant'])): ?>
                <div class="col-md-3">
                    <label class="form-label">
                        <i class="bi bi-people"></i>
                        الشريك
                    </label>
                    <select class="form-select shadow-none" name="partner_id">
                        <option value="">الكل</option>
                        <?php $__currentLoopData = $partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($partner->id); ?>">
                                <?php echo e($partner->name); ?> (<?php echo e($partner->share); ?>%)
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <?php endif; ?>
                <div class="col-md-3">
                    <label class="form-label">
                        <i class="bi bi-calendar3"></i>
                        من تاريخ
                    </label>
                    <input type="date" class="form-control shadow-none" name="from_date">
                </div>
                <div class="col-md-3">
                    <label class="form-label">
                        <i class="bi bi-calendar3"></i>
                        إلى تاريخ
                    </label>
                    <input type="date" class="form-control shadow-none" name="to_date">
                </div>
                <div class="col-md-3">
                    <label class="form-label">
                        <i class="bi bi-tag"></i>
                        النوع
                    </label>
                    <select class="form-select shadow-none" name="type">
                        <option value="">الكل</option>
                        <option value="income">إيراد</option>
                        <option value="expense">مصروف</option>
                    </select>
                </div>
                <div class="col-12">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-search"></i>
                        تصفية
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                    </button>
                    <button type="reset" class="btn btn-outline-secondary">
                        <i class="bi bi-x-circle"></i>
                        مسح
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- جدول المعاملات -->
<div class="card shadow-sm">
    <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
        <h5 class="mb-0"><i class="bi bi-table"></i> المعاملات</h5>
        <div class="btn-group">
            <button type="button" class="btn btn-outline-primary btn-sm" id="exportToExcel">
                <i class="bi bi-file-excel"></i>
                تصدير Excel
            </button>
            <button type="button" class="btn btn-outline-primary btn-sm" id="printTable">
                <i class="bi bi-printer"></i>
                طباعة
            </button>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-hover transactions-table">
                <thead class="table-light">
                    <tr>
                        <th>التاريخ</th>
                        <th>النوع</th>
                        <th>التصنيف</th>
                        <th>المبلغ</th>
                        <th>الشريك</th>
                        <th>الوصف</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- سيتم تحديث البيانات عبر JavaScript -->
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// دالة تنسيق الأرقام
function number_format(number, decimals = 0) {
    return new Intl.NumberFormat('en-US', {
        minimumFractionDigits: decimals,
        maximumFractionDigits: decimals
    }).format(number);
}

// تعريف الدوال خارج document.ready
function exportToExcel() {
    // إنشاء مصفوفة البيانات
    const data = [
        ['التاريخ', 'النوع', 'التصنيف', 'المبلغ', 'الشريك', 'الوصف']
    ];

    // إضافة المعاملات
    $('.transactions-table tbody tr').each(function() {
        const row = [];
        $(this).find('td').each(function(index) {
            // استخراج النص فقط بدون HTML
            let cellText = '';
            if (index === 1) { // عمود النوع
                cellText = $(this).text().trim() === 'إيراد' ? 'إيراد' : 'مصروف';
            } else if (index === 2) { // عمود التصنيف
                cellText = $(this).text().trim();
            } else if (index === 3) { // عمود المبلغ
                cellText = $(this).text().replace(' JOD', '').trim();
            } else if (index === 4) { // عمود الشريك
                cellText = $(this).text().replace(/\(\d+%\)/, '').trim();
            } else {
                cellText = $(this).text().trim();
            }
            row.push(cellText);
        });
        data.push(row);
    });

    // إضافة سطر فارغ
    data.push([]);

    // إضافة الإجماليات
    data.push(
        ['الإجماليات'],
        ['إجمالي الإيرادات', $('#total-income').text()],
        ['إجمالي المصروفات', $('#total-expense').text()],
        ['صافي الربح', $('#net-profit').text()]
    );

    // إضافة سطر فارغ
    data.push([]);

    // // إضافة حصص الشركاء
    // data.push(['حصص الشركاء']);
    // data.push(['الشريك', 'النسبة الأصلية', 'النسبة الفعلية', 'الحصة']);
    
    // $('.partners-table tbody tr').each(function() {
    //     const row = [];
    //     $(this).find('td').each(function() {
    //         row.push($(this).text().trim());
    //     });
    //     data.push(row);
    // });

    // إنشاء workbook وworksheet
    const ws = XLSX.utils.aoa_to_sheet(data);
    const wb = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(wb, ws, "التقرير");

    // تعديل عرض الأعمدة
    const columnWidths = [
        { wch: 12 }, // التاريخ
        { wch: 10 }, // النوع
        { wch: 15 }, // التصنيف
        { wch: 15 }, // المبلغ
        { wch: 20 }, // الشريك
        { wch: 30 }  // الوصف
    ];
    ws['!cols'] = columnWidths;

    // تنسيق الخلايا للغة العربية
    for (let cell in ws) {
        if (cell[0] === '!') continue;
        ws[cell].s = { alignment: { horizontal: "right" } };
    }

    // تحديد اسم الملف
    const currentDate = new Date().toISOString().split('T')[0];
    const fileName = `تقرير_المعاملات_${currentDate}.xlsx`;

    // تصدير الملف
    XLSX.writeFile(wb, fileName);
}

function printTable() {
    window.print();
}

$(document).ready(function() {
    // إضافة CSRF token لجميع طلبات AJAX
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // تصفية التقارير
    $('#filterForm').on('submit', function(e) {
        e.preventDefault();
        
        const submitBtn = $(this).find('button[type="submit"]');
        const spinner = submitBtn.find('.spinner-border');
        
        submitBtn.prop('disabled', true);
        spinner.removeClass('d-none');

        $.ajax({
            url: '<?php echo e(route("reports.filter")); ?>',
            method: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                if (response.success) {
                    updateTable(response);
                } else {
                    showAlert('error', response.message || 'حدث خطأ في تصفية البيانات');
                }
            },
            error: function(xhr) {
                let errorMessage = 'حدث خطأ في تصفية البيانات';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                }
                showAlert('error', errorMessage);
            },
            complete: function() {
                submitBtn.prop('disabled', false);
                spinner.addClass('d-none');
            }
        });
    });

    // دالة تحديث الجدول
    function updateTable(response) {
        if (!response.transactions) return;

        // تحديث جدول المعاملات
        const tbody = $('.transactions-table tbody');
        tbody.empty();

        const isAdminOrAccountant = <?php echo e(auth()->user()->hasRole(['admin', 'accountant']) ? 'true' : 'false'); ?>;
        const partnerShare = <?php echo e(auth()->user()->partner->share ?? 0); ?>;

        response.transactions.forEach(function(transaction) {
            const formattedDate = formatDate(transaction.transaction_date);
            
            // التحقق من وجود التصنيف
            let categoryName = transaction.category;
            let categoryIcon = 'bi bi-circle';
            let categoryColor = '#6c757d';

            if (response.categories && 
                response.categories[transaction.type] && 
                response.categories[transaction.type][transaction.category]) {
                const category = response.categories[transaction.type][transaction.category];
                categoryName = category.name || transaction.category;
                categoryIcon = category.icon || 'bi bi-circle';
                categoryColor = category.color || '#6c757d';
            }

            // تنسيق عرض الشريك
            let partnerDisplay = '';
            if (transaction.partner) {
                partnerDisplay = `<i class="bi bi-person-circle me-1"></i>${transaction.partner.name}`;
                if (transaction.partner.share) {
                    partnerDisplay += ` <small class="text-muted">(${transaction.partner.share}%)</small>`;
                }
            } else {
                partnerDisplay = '<i class="bi bi-people me-1"></i>معاملة عامة';
                if (!isAdminOrAccountant) {
                    partnerDisplay += ` <small class="text-muted">(${partnerShare}%)</small>`;
                }
            }

            const row = `
                <tr>
                    <td class="text-nowrap">${formattedDate}</td>
                    <td>
                        <span class="badge ${transaction.type === 'income' ? 'bg-success' : 'bg-danger'}">
                            ${transaction.type === 'income' ? 'إيراد' : 'مصروف'}
                        </span>
                    </td>
                    <td>
                        <i class="${categoryIcon}" style="color: ${categoryColor}"></i>
                        ${categoryName}
                    </td>
                    <td class="text-nowrap">${number_format(transaction.amount, 3)} JOD</td>
                    <td>${partnerDisplay}</td>
                    <td>${transaction.description || '-'}</td>
                </tr>
            `;
            tbody.append(row);
        });

        // تحديث جدول الحصص
        if (response.partnerShares && response.partnerShares.length > 0) {
            const sharesBody = $('.partners-table tbody');
            sharesBody.empty();

            response.partnerShares.forEach(function(share) {
                const row = `
                    <tr>
                        <td>
                            <i class="bi bi-person-circle me-1"></i>
                            ${share.name}
                        </td>
                        <td class="text-nowrap">${number_format(share.percentage, 2)}%</td>
                        <td class="text-nowrap">${number_format(share.adjusted_percentage, 2)}%</td>
                        <td class="text-nowrap">${number_format(share.share, 3)} JOD</td>
                    </tr>
                `;
                sharesBody.append(row);
            });

            // إضافة صف المجموع
            const totalPercentage = response.partnerShares.reduce((sum, share) => sum + share.percentage, 0);
            const totalShare = response.partnerShares.reduce((sum, share) => sum + share.share, 0);

            sharesBody.append(`
                <tr class="table-secondary fw-bold">
                    <td>المجموع</td>
                    <td class="text-nowrap">${number_format(totalPercentage, 2)}%</td>
                    <td class="text-nowrap">100.00%</td>
                    <td class="text-nowrap">${number_format(totalShare, 3)} JOD</td>
                </tr>
            `);
        }

        // تحديث البطاقات العلوية
        if (response.totals) {
            $('#total-income').text(number_format(response.totals.income, 3) + ' JOD');
            $('#total-expense').text(number_format(response.totals.expense, 3) + ' JOD');
            $('#net-profit')
                .text(number_format(response.totals.net, 3) + ' JOD')
                .closest('.card')
                .removeClass('bg-danger bg-primary')
                .addClass(response.totals.net >= 0 ? 'bg-primary' : 'bg-danger');
        }
    }

    // دالة مساعدة لعرض التنبيهات
    function showAlert(type, message) {
        const alertDiv = $('<div>')
            .addClass(`alert alert-${type} alert-dismissible fade show`)
            .attr('role', 'alert')
            .html(`
                <i class="bi bi-${type === 'success' ? 'check-circle' : 'exclamation-circle'} me-2"></i>
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `);

        $('.card-body:first').prepend(alertDiv);
        
        setTimeout(() => {
            alertDiv.alert('close');
        }, 3000);
    }

    // تنظيف الفورم عند الضغط على زر المسح
    $('#filterForm button[type="reset"]').on('click', function() {
        setTimeout(() => {
            $('#filterForm').submit();
        }, 0);
    });

    // إضافة معالجات الأحداث للأزرار
    $('#exportToExcel').on('click', exportToExcel);
    $('#printTable').on('click', printTable);
});
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\GitHub\partners_system\resources\views/reports/index.blade.php ENDPATH**/ ?>