

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5>إدارة الشركاء</h5>
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPartnerModal">
            إضافة شريك جديد
        </button>
    </div>
    <div class="card-body">
        <table class="table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>الاسم</th>
                    <th>النسبة</th>
                    <th>الإجراءات</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($partner->name); ?></td>
                    <td><?php echo e($partner->percentage); ?>%</td>
                    <td>
                        <button class="btn btn-sm btn-warning edit-partner" 
                                data-partner="<?php echo e($partner->id); ?>">تعديل</button>
                        <button class="btn btn-sm btn-danger delete-partner" 
                                data-partner="<?php echo e($partner->id); ?>">حذف</button>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal إضافة شريك -->
<div class="modal fade" id="addPartnerModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">إضافة شريك جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addPartnerForm">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">اسم الشريك <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">النسبة المئوية <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="number" 
                                   class="form-control" 
                                   name="percentage" 
                                   min="0" 
                                   max="100" 
                                   step="0.01" 
                                   value="0"
                                   required>
                            <span class="input-group-text">%</span>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">البريد الإلكتروني</label>
                        <input type="email" class="form-control" name="email">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">رقم الهاتف</label>
                        <input type="text" class="form-control" name="phone">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">العنوان</label>
                        <textarea class="form-control" name="address"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal تعديل شريك -->
<div class="modal fade" id="editPartnerModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تعديل بيانات الشريك</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="editPartnerForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="partner_id" id="edit_partner_id">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">اسم الشريك <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="name" id="edit_name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">النسبة المئوية <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="number" 
                                   class="form-control" 
                                   name="percentage" 
                                   id="edit_percentage"
                                   min="0" 
                                   max="100" 
                                   step="0.01" 
                                   required>
                            <span class="input-group-text">%</span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // إضافة CSRF token لجميع طلبات AJAX
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // إضافة شريك جديد
    $('#addPartnerForm').on('submit', function(e) {
        e.preventDefault();
        
        // تعطيل زر الحفظ
        const submitBtn = $(this).find('button[type="submit"]');
        submitBtn.prop('disabled', true);
        
        $.ajax({
            url: '<?php echo e(route("partners.store")); ?>',
            method: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                $('#addPartnerModal').modal('hide');
                showAlert('success', response.message);
                setTimeout(() => location.reload(), 1500);
            },
            error: function(xhr) {
                let errorMessage = 'حدث خطأ ما';
                if (xhr.responseJSON) {
                    if (xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    } else if (xhr.responseJSON.errors) {
                        errorMessage = Object.values(xhr.responseJSON.errors).flat().join('\n');
                    }
                }
                showAlert('error', errorMessage);
            },
            complete: function() {
                // إعادة تفعيل زر الحفظ
                submitBtn.prop('disabled', false);
            }
        });
    });

    // معالجة زر التعديل
    $('.edit-partner').on('click', function() {
        const partnerId = $(this).data('partner');
        const row = $(this).closest('tr');
        
        // تعبئة النموذج بالبيانات
        $('#edit_partner_id').val(partnerId);
        $('#edit_name').val(row.find('td:eq(1)').text());
        $('#edit_percentage').val(parseFloat(row.find('td:eq(2)').text()));
        
        // فتح النافذة المنبثقة
        $('#editPartnerModal').modal('show');
    });

    // تعديل شريك
    $('#editPartnerForm').on('submit', function(e) {
        e.preventDefault();
        const id = $('#edit_partner_id').val();
        
        // تعطيل زر الحفظ
        const submitBtn = $(this).find('button[type="submit"]');
        submitBtn.prop('disabled', true);

        $.ajax({
            url: `/partners/${id}`,
            method: 'PUT',
            data: $(this).serialize(),
            success: function(response) {
                $('#editPartnerModal').modal('hide');
                showAlert('success', response.message);
                setTimeout(() => location.reload(), 1500);
            },
            error: function(xhr) {
                let errorMessage = 'حدث خطأ ما';
                if (xhr.responseJSON) {
                    if (xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    } else if (xhr.responseJSON.errors) {
                        errorMessage = Object.values(xhr.responseJSON.errors).flat().join('\n');
                    }
                }
                showAlert('error', errorMessage);
            },
            complete: function() {
                // إعادة تفعيل زر الحفظ
                submitBtn.prop('disabled', false);
            }
        });
    });

    // تنظيف النموذج عند إغلاق النافذة المنبثقة
    $('#editPartnerModal').on('hidden.bs.modal', function() {
        $('#editPartnerForm')[0].reset();
        $('#edit_partner_id').val('');
    });

    // حذف شريك
    window.deletePartner = function(id) {
        if (confirm('هل أنت متأكد من حذف هذا الشريك؟')) {
            $.ajax({
                url: `/partners/${id}`,
                method: 'DELETE',
                success: function(response) {
                    showAlert('success', response.message);
                    setTimeout(() => location.reload(), 1500);
                },
                error: function(xhr) {
                    let errorMessage = 'حدث خطأ ما';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }
                    showAlert('error', errorMessage);
                }
            });
        }
    };

    // دالة مساعدة لعرض التنبيهات
    function showAlert(type, message) {
        const alertDiv = $('<div>')
            .addClass(`alert alert-${type} alert-dismissible fade show`)
            .attr('role', 'alert')
            .html(`
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `);

        // إضافة التنبيه في بداية card-body
        $('.card-body').prepend(alertDiv);
        
        // إزالة التنبيه بعد 3 ثواني
        setTimeout(() => {
            alertDiv.alert('close');
        }, 3000);
    }
});
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\DELL\Desktop\partners_system\resources\views/partners/index.blade.php ENDPATH**/ ?>