<div class="card">
    <div class="card-header">
        <h5>الأدوار والصلاحيات</h5>
    </div>
    <div class="card-body">
        <div class="accordion" id="rolesAccordion">
            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="accordion-item">
                <h2 class="accordion-header">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#role<?php echo e($role->id); ?>">
                        <?php echo e($role->display_name); ?>

                    </button>
                </h2>
                <div id="role<?php echo e($role->id); ?>" class="accordion-collapse collapse" data-bs-parent="#rolesAccordion">
                    <div class="accordion-body">
                        <form class="role-permissions-form" data-role-id="<?php echo e($role->id); ?>">
                            <div class="row">
                                <?php $__currentLoopData = $permissions->chunk(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4">
                                    <?php $__currentLoopData = $chunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" 
                                            name="permissions[]" 
                                            value="<?php echo e($permission->name); ?>"
                                            id="perm<?php echo e($role->id); ?>_<?php echo e($permission->id); ?>"
                                            <?php echo e($role->permissions->contains($permission) ? 'checked' : ''); ?>

                                            <?php echo e($role->name === 'admin' ? 'disabled' : ''); ?>>
                                        <label class="form-check-label" for="perm<?php echo e($role->id); ?>_<?php echo e($permission->id); ?>">
                                            <?php echo e($permission->display_name); ?>

                                        </label>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <?php if($role->name !== 'admin'): ?>
                            <button type="submit" class="btn btn-primary mt-3">حفظ الصلاحيات</button>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
$('.role-permissions-form').on('submit', function(e) {
    e.preventDefault();
    const roleId = $(this).data('role-id');
    
    $.ajax({
        url: `/settings/roles/${roleId}/permissions`,
        method: 'PUT',
        data: $(this).serialize(),
        success: function(response) {
            showAlert('success', response.message);
        },
        error: function(xhr) {
            showAlert('error', xhr.responseJSON?.message || 'حدث خطأ أثناء تحديث الصلاحيات');
        }
    });
});
</script>
<?php $__env->stopPush(); ?><?php /**PATH D:\partners_system\resources\views/settings/partials/roles.blade.php ENDPATH**/ ?>