<div class="table-responsive">
    <table class="table transactions-table">
        <thead>
            <tr>
                <th>التاريخ</th>
                <th>النوع</th>
                <th>التصنيف</th>
                <th>المبلغ</th>
                <th>الوصف</th>
                <?php if(auth()->user()->hasRole('admin')): ?>
                <th>الشريك</th>
                <?php endif; ?>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($transaction->transaction_date ? $transaction->transaction_date->format('Y-m-d') : ''); ?></td>
                <td>
                    <span class="badge bg-<?php echo e($transaction->type == 'income' ? 'success' : 'danger'); ?>">
                        <?php echo e($transaction->type == 'income' ? 'إيراد' : 'مصروف'); ?>

                    </span>
                </td>
                <td>
                    <i class="<?php echo e($transaction->category_icon); ?> text-<?php echo e($transaction->category_color); ?> me-1"></i>
                    <?php echo e($transaction->category_name); ?>

                </td>
                <td><?php echo e(number_format($transaction->amount, 3)); ?> JOD</td>
                <td><?php echo e($transaction->description ?: '-'); ?></td>
                <?php if(auth()->user()->hasRole('admin')): ?>
                <td><?php echo e($transaction->partner->name ?? '-'); ?></td>
                <?php endif; ?>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div> <?php /**PATH C:\Users\DELL\Desktop\partners_system\resources\views/reports/partials/transactions-table.blade.php ENDPATH**/ ?>