<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\PartnerController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\InvoiceController;

// مسارات المصادقة
Route::middleware('guest')->group(function () {
    Route::get('login', [AuthController::class, 'showLoginForm'])->name('login');
    Route::post('login', [AuthController::class, 'login']);
});

Route::post('logout', [AuthController::class, 'logout'])->name('logout');

// المسارات المحمية
Route::middleware('auth')->group(function () {
    Route::get('/', function () {
        return redirect()->route('reports.index');
    });

    // المعاملات
    Route::group(['prefix' => 'transactions', 'as' => 'transactions.'], function () {
        Route::get('/', [TransactionController::class, 'index'])
            ->name('index')
            ->middleware('permission:transactions-list');
        Route::post('/', [TransactionController::class, 'store'])
            ->name('store')
            ->middleware('permission:transactions-create');
        Route::put('/{transaction}', [TransactionController::class, 'update'])
            ->name('update')
            ->middleware('permission:transactions-edit');
        Route::delete('/{transaction}', [TransactionController::class, 'destroy'])
            ->name('destroy')
            ->middleware('permission:transactions-delete');
    });

    // التقارير
    Route::group(['prefix' => 'reports', 'as' => 'reports.'], function () {
        Route::get('/', [ReportController::class, 'index'])
            ->name('index')
            ->middleware('permission:reports-list');
        Route::get('/export', [ReportController::class, 'export'])
            ->name('export')
            ->middleware('permission:reports-export');
        Route::post('/filter', [ReportController::class, 'filter'])
            ->name('filter')
            ->middleware('permission:reports-list');
    });

    // الشركاء
    Route::group(['prefix' => 'partners', 'as' => 'partners.'], function () {
        Route::get('/', [PartnerController::class, 'index'])
            ->name('index')
            ->middleware('permission:partners-list');
        Route::post('/', [PartnerController::class, 'store'])
            ->name('store')
            ->middleware('permission:partners-create');
        Route::put('/{partner}', [PartnerController::class, 'update'])
            ->name('update')
            ->middleware('permission:partners-edit');
        Route::delete('/{partner}', [PartnerController::class, 'destroy'])
            ->name('destroy')
            ->middleware('permission:partners-delete');
    });

    // طرق الإعدادات - تحتاج إلى صلاحية المدير
    Route::middleware(['auth', 'role:admin'])->group(function () {
        Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
        Route::post('/settings/users', [SettingsController::class, 'storeUser'])->name('settings.storeUser');
        Route::put('/settings/users/{user}', [SettingsController::class, 'updateUser'])->name('settings.updateUser');
        Route::delete('/settings/users/{user}', [SettingsController::class, 'destroyUser'])->name('settings.destroyUser');
        Route::put('/settings/roles/{role}/permissions', [SettingsController::class, 'updateRolePermissions'])
            ->name('settings.roles.permissions.update');
        Route::put('/settings/general', [SettingsController::class, 'updateGeneralSettings'])
            ->name('settings.general.update');
        Route::post('/settings/categories', [SettingsController::class, 'updateCategories'])
            ->name('settings.categories.update');
        Route::delete('/settings/logo', [SettingsController::class, 'deleteLogo'])
            ->name('settings.logo.delete');
        Route::delete('/settings/favicon', [SettingsController::class, 'deleteFavicon'])
            ->name('settings.favicon.delete');
    });

    // مسارات الملف الشخصي
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::put('/profile', [ProfileController::class, 'update'])->name('profile.update');

    Route::get('/invoices', [InvoiceController::class, 'index'])->name('invoices.index');
    Route::get('/invoices/{invoice}', [InvoiceController::class, 'show'])->name('invoices.show');
    Route::post('/invoices/{invoice}/status', [InvoiceController::class, 'updateStatus'])->name('invoices.updateStatus');

    // راوتات الشركاء
    Route::get('/partners', [PartnerController::class, 'index'])->name('partners.index');
    Route::post('/partners', [PartnerController::class, 'store'])->name('partners.store');
    Route::get('/partners/{partner}', [PartnerController::class, 'show'])->name('partners.show');
    Route::put('/partners/{partner}', [PartnerController::class, 'update'])->name('partners.update');
    Route::delete('/partners/{partner}', [PartnerController::class, 'destroy'])->name('partners.destroy');

    // راوتات الإعدادات
    Route::prefix('settings')->name('settings.')->group(function () {
        Route::get('/', [SettingsController::class, 'index'])->name('index');
        Route::post('/update', [SettingsController::class, 'update'])->name('update');
        Route::post('/categories', [SettingsController::class, 'updateCategories'])->name('categories.update');
        Route::delete('/logo', [SettingsController::class, 'deleteLogo'])->name('logo.delete');
        Route::delete('/favicon', [SettingsController::class, 'deleteFavicon'])->name('favicon.delete');
    });
});
