<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5>إدارة المستخدمين</h5>
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addUserModal">
            إضافة مستخدم جديد
        </button>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>الاسم</th>
                        <th>البريد الإلكتروني</th>
                        <th>الدور</th>
                        <th>الشريك</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($users as $user)
                    <tr>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->email }}</td>
                        <td>{{ $user->roles->first()->display_name ?? '' }}</td>
                        <td>{{ $user->partner->name ?? '' }}</td>
                        <td>
                            <button class="btn btn-sm btn-warning" onclick="editUser({{ $user->id }}, '{{ $user->name }}', '{{ $user->email }}', '{{ $user->roles->first()->name ?? '' }}', {{ $user->partner_id ?? 'null' }})">
                                تعديل
                            </button>
                            @if(!$user->hasRole('admin'))
                            <button class="btn btn-sm btn-danger" onclick="deleteUser({{ $user->id }})">
                                حذف
                            </button>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal إضافة مستخدم -->
<div class="modal fade" id="addUserModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">إضافة مستخدم جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addUserForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">الاسم</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">البريد الإلكتروني</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">كلمة المرور</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">الدور</label>
                        <select name="role" class="form-control" required>
                            @foreach($roles as $role)
                            <option value="{{ $role->name }}">{{ $role->display_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">الشريك</label>
                        <select name="partner_id" class="form-control">
                            <option value="">بدون شريك</option>
                            @foreach($partners as $partner)
                            <option value="{{ $partner->id }}">{{ $partner->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal تعديل مستخدم -->
<div class="modal fade" id="editUserModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تعديل مستخدم</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="editUserForm">
                <input type="hidden" id="edit_user_id">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">الاسم</label>
                        <input type="text" id="edit_name" name="name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">البريد الإلكتروني</label>
                        <input type="email" id="edit_email" name="email" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">كلمة المرور</label>
                        <input type="password" name="password" class="form-control" placeholder="اتركها فارغة إذا لم ترد تغييرها">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">الدور</label>
                        <select id="edit_role" name="role" class="form-control" required>
                            @foreach($roles as $role)
                            <option value="{{ $role->name }}">{{ $role->display_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">الشريك</label>
                        <select id="edit_partner_id" name="partner_id" class="form-control">
                            <option value="">بدون شريك</option>
                            @foreach($partners as $partner)
                            <option value="{{ $partner->id }}">{{ $partner->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
// إضافة مستخدم جديد
$('#addUserForm').on('submit', function(e) {
    e.preventDefault();
    $.ajax({
        url: '{{ route("settings.storeUser") }}',
        method: 'POST',
        data: $(this).serialize(),
        success: function(response) {
            $('#addUserModal').modal('hide');
            showAlert('success', response.message);
            setTimeout(() => location.reload(), 1500);
        },
        error: function(xhr) {
            showAlert('error', xhr.responseJSON?.message || 'حدث خطأ أثناء إضافة المستخدم');
        }
    });
});

// تعديل مستخدم
window.editUser = function(id, name, email, role, partnerId) {
    $('#edit_user_id').val(id);
    $('#edit_name').val(name);
    $('#edit_email').val(email);
    $('#edit_role').val(role);
    $('#edit_partner_id').val(partnerId);
    $('#editUserModal').modal('show');
};

$('#editUserForm').on('submit', function(e) {
    e.preventDefault();
    const userId = $('#edit_user_id').val();
    
    $.ajax({
        url: `/settings/users/${userId}`,
        method: 'PUT',
        data: $(this).serialize(),
        success: function(response) {
            $('#editUserModal').modal('hide');
            showAlert('success', response.message);
            setTimeout(() => location.reload(), 1500);
        },
        error: function(xhr) {
            showAlert('error', xhr.responseJSON?.message || 'حدث خطأ أثناء تحديث المستخدم');
        }
    });
});

// حذف مستخدم
window.deleteUser = function(id) {
    if (confirm('هل أنت متأكد من حذف هذا المستخدم؟')) {
        $.ajax({
            url: `/settings/users/${id}`,
            method: 'DELETE',
            success: function(response) {
                showAlert('success', response.message);
                setTimeout(() => location.reload(), 1500);
            },
            error: function(xhr) {
                showAlert('error', xhr.responseJSON?.message || 'حدث خطأ أثناء حذف المستخدم');
            }
        });
    }
};
</script>
@endpush 