<div class="card">
    <div class="card-header">
        <h5>الأدوار والصلاحيات</h5>
    </div>
    <div class="card-body">
        <div class="accordion" id="rolesAccordion">
            @foreach($roles as $role)
            <div class="accordion-item">
                <h2 class="accordion-header">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#role{{ $role->id }}">
                        {{ $role->display_name }}
                    </button>
                </h2>
                <div id="role{{ $role->id }}" class="accordion-collapse collapse" data-bs-parent="#rolesAccordion">
                    <div class="accordion-body">
                        <form class="role-permissions-form" data-role-id="{{ $role->id }}">
                            <div class="row">
                                @foreach($permissions->chunk(3) as $chunk)
                                <div class="col-md-4">
                                    @foreach($chunk as $permission)
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" 
                                            name="permissions[]" 
                                            value="{{ $permission->name }}"
                                            id="perm{{ $role->id }}_{{ $permission->id }}"
                                            {{ $role->permissions->contains($permission) ? 'checked' : '' }}
                                            {{ $role->name === 'admin' ? 'disabled' : '' }}>
                                        <label class="form-check-label" for="perm{{ $role->id }}_{{ $permission->id }}">
                                            {{ $permission->display_name }}
                                        </label>
                                    </div>
                                    @endforeach
                                </div>
                                @endforeach
                            </div>
                            @if($role->name !== 'admin')
                            <button type="submit" class="btn btn-primary mt-3">حفظ الصلاحيات</button>
                            @endif
                        </form>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>

@push('scripts')
<script>
$('.role-permissions-form').on('submit', function(e) {
    e.preventDefault();
    const roleId = $(this).data('role-id');
    
    $.ajax({
        url: `/settings/roles/${roleId}/permissions`,
        method: 'PUT',
        data: $(this).serialize(),
        success: function(response) {
            showAlert('success', response.message);
        },
        error: function(xhr) {
            showAlert('error', xhr.responseJSON?.message || 'حدث خطأ أثناء تحديث الصلاحيات');
        }
    });
});
</script>
@endpush