@php
use App\Models\Setting;
use Illuminate\Support\Facades\Storage;
@endphp

<div class="card">
    <div class="card-header">
        <h5>الإعدادات العامة</h5>
    </div>
    <div class="card-body">
        <form action="{{ route('settings.general.update') }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            
            <div class="mb-3">
                <label class="form-label">اسم التطبيق</label>
                <input type="text" name="app_name" class="form-control" 
                    value="{{ Setting::get('app_name', config('app.name')) }}" required>
            </div>

            <div class="mb-3">
                <label class="form-label">الشعار</label>
                @if($logo = Setting::get('logo'))
                    <div class="mb-2">
                        <img src="{{ Storage::url($logo) }}" alt="Logo" class="img-thumbnail" style="height: 50px">
                        <button type="button" class="btn btn-sm btn-danger" onclick="deleteLogo()">
                            <i class="bi bi-trash"></i>
                        </button>
                    </div>
                @endif
                <input type="file" name="logo" class="form-control" accept="image/*">
            </div>

            <div class="mb-3">
                <label class="form-label">الأيقونة المفضلة</label>
                @if($favicon = Setting::get('favicon'))
                    <div class="mb-2">
                        <img src="{{ Storage::url($favicon) }}" alt="Favicon" class="img-thumbnail" style="height: 32px">
                        <button type="button" class="btn btn-sm btn-danger" onclick="deleteFavicon()">
                            <i class="bi bi-trash"></i>
                        </button>
                    </div>
                @endif
                <input type="file" name="favicon" class="form-control" accept="image/x-icon,image/png">
            </div>

            <div class="mb-3">
                <label class="form-label">نص التذييل</label>
                <textarea name="footer_text" class="form-control" rows="2">{{ Setting::get('footer_text') }}</textarea>
            </div>

            <div class="mb-3">
                <label class="form-label">العملة</label>
                <input type="text" name="currency" class="form-control" 
                    value="{{ Setting::get('currency', 'JOD') }}" required>
            </div>

            <div class="mb-3">
                <label class="form-label">المنطقة الزمنية</label>
                <select name="timezone" class="form-control" required>
                    @foreach(timezone_identifiers_list() as $timezone)
                        <option value="{{ $timezone }}" 
                            {{ Setting::get('timezone', config('app.timezone')) == $timezone ? 'selected' : '' }}>
                            {{ $timezone }}
                        </option>
                    @endforeach
                </select>
            </div>

            <button type="submit" class="btn btn-primary">حفظ الإعدادات</button>
        </form>
    </div>
</div>

@push('scripts')
<script>
function deleteLogo() {
    if (confirm('هل أنت متأكد من حذف الشعار؟')) {
        $.ajax({
            url: '{{ route("settings.logo.delete") }}',
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(response) {
                showAlert('success', response.message);
                setTimeout(() => location.reload(), 1500);
            },
            error: function(xhr) {
                showAlert('error', 'حدث خطأ أثناء حذف الشعار');
            }
        });
    }
}

function deleteFavicon() {
    if (confirm('هل أنت متأكد من حذف الأيقونة المفضلة؟')) {
        $.ajax({
            url: '{{ route("settings.favicon.delete") }}',
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(response) {
                showAlert('success', response.message);
                setTimeout(() => location.reload(), 1500);
            },
            error: function(xhr) {
                showAlert('error', 'حدث خطأ أثناء حذف الأيقونة المفضلة');
            }
        });
    }
}
</script>
@endpush