<div class="table-responsive">
    <table class="table transactions-table">
        <thead>
            <tr>
                <th>التاريخ</th>
                <th>النوع</th>
                <th>التصنيف</th>
                <th>المبلغ</th>
                <th>الوصف</th>
                @if(auth()->user()->hasRole('admin'))
                <th>الشريك</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @foreach($transactions as $transaction)
            <tr>
                <td>{{ $transaction->transaction_date ? $transaction->transaction_date->format('Y-m-d') : '' }}</td>
                <td>
                    <span class="badge bg-{{ $transaction->type == 'income' ? 'success' : 'danger' }}">
                        {{ $transaction->type == 'income' ? 'إيراد' : 'مصروف' }}
                    </span>
                </td>
                <td>
                    <i class="{{ $transaction->category_icon }} text-{{ $transaction->category_color }} me-1"></i>
                    {{ $transaction->category_name }}
                </td>
                <td>{{ number_format($transaction->amount, 3) }} JOD</td>
                <td>{{ $transaction->description ?: '-' }}</td>
                @if(auth()->user()->hasRole('admin'))
                <td>{{ $transaction->partner->name ?? '-' }}</td>
                @endif
            </tr>
            @endforeach
        </tbody>
    </table>
</div> 