@extends('layouts.app')

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="container">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5>الشركاء</h5>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPartnerModal">
                إضافة شريك جديد
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>الاسم</th>
                            <th>كود المستخدم</th>
                            <th>البريد الإلكتروني</th>
                            <th>رقم الهاتف</th>
                            <th>العنوان</th>
                            <th>النسبة</th>
                            <th>رقم الهوية</th>
                            <th>البنك</th>
                            <th>الحالة</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($partners as $partner)
                        <tr>
                            <td>{{ $partner->id }}</td>
                            <td>{{ $partner->name }}</td>
                            <td>{{ $partner->user_code ?: '-' }}</td>
                            <td>{{ $partner->email }}</td>
                            <td>{{ $partner->phone }}</td>
                            <td>{{ $partner->address }}</td>
                            <td>{{ number_format($partner->percentage, 2) }}%</td>
                            <td>{{ $partner->national_id }}</td>
                            <td>{{ $partner->bank_name }}</td>
                            <td>
                                <span class="badge bg-{{ $partner->status === 'active' ? 'success' : 'danger' }}">
                                    {{ $partner->status === 'active' ? 'نشط' : 'غير نشط' }}
                                </span>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-sm btn-info view-partner" data-id="{{ $partner->id }}">
                                        <i class="bi bi-eye"></i>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-primary edit-partner" data-id="{{ $partner->id }}">
                                        <i class="bi bi-pencil"></i>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-danger delete-partner" data-id="{{ $partner->id }}">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal إضافة شريك -->
<div class="modal fade" id="addPartnerModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">إضافة شريك جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addPartnerForm">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">الاسم <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">كود المستخدم في نظام الفوترة</label>
                            <input type="text" class="form-control" name="user_code" 
                                   placeholder="مثال: ABC123">
                            <small class="text-muted">مخصص للربط مع نظام الفوترة</small>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">البريد الإلكتروني</label>
                            <input type="email" class="form-control" name="email">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">رقم الهاتف</label>
                            <input type="text" class="form-control" name="phone">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">النسبة المئوية <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="percentage" step="0.01" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">العنوان</label>
                            <input type="text" class="form-control" name="address">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">رقم الهوية</label>
                            <input type="text" class="form-control" name="national_id">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">اسم البنك</label>
                            <input type="text" class="form-control" name="bank_name">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">رقم الحساب</label>
                            <input type="text" class="form-control" name="bank_account">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">رقم الآيبان</label>
                            <input type="text" class="form-control" name="bank_iban">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">ملاحظات</label>
                        <textarea class="form-control" name="notes" rows="3"></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">الحالة</label>
                        <select class="form-select" name="status">
                            <option value="active">نشط</option>
                            <option value="inactive">غير نشط</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal عرض تفاصيل الشريك -->
<div class="modal fade" id="viewPartnerModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تفاصيل الشريك</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>المعلومات الشخصية</h6>
                        <hr>
                        <dl class="row">
                            <dt class="col-sm-4">الاسم:</dt>
                            <dd class="col-sm-8" id="view_name"></dd>
                            
                            <dt class="col-sm-4">كود المستخدم:</dt>
                            <dd class="col-sm-8" id="view_user_code"></dd>
                            
                            <dt class="col-sm-4">البريد الإلكتروني:</dt>
                            <dd class="col-sm-8" id="view_email"></dd>
                            
                            <dt class="col-sm-4">رقم الهاتف:</dt>
                            <dd class="col-sm-8" id="view_phone"></dd>
                            
                            <dt class="col-sm-4">العنوان:</dt>
                            <dd class="col-sm-8" id="view_address"></dd>
                            
                            <dt class="col-sm-4">رقم الهوية:</dt>
                            <dd class="col-sm-8" id="view_national_id"></dd>
                        </dl>
                    </div>
                    <div class="col-md-6">
                        <h6>المعلومات المالية</h6>
                        <hr>
                        <dl class="row">
                            <dt class="col-sm-4">النسبة:</dt>
                            <dd class="col-sm-8" id="view_percentage"></dd>
                            
                            <dt class="col-sm-4">البنك:</dt>
                            <dd class="col-sm-8" id="view_bank_name"></dd>
                            
                            <dt class="col-sm-4">رقم الحساب:</dt>
                            <dd class="col-sm-8" id="view_bank_account"></dd>
                            
                            <dt class="col-sm-4">رقم الآيبان:</dt>
                            <dd class="col-sm-8" id="view_bank_iban"></dd>
                        </dl>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <h6>ملاحظات</h6>
                        <hr>
                        <p id="view_notes"></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal تعديل الشريك -->
<div class="modal fade" id="editPartnerModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تعديل الشريك</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="editPartnerForm">
                @csrf
                @method('PUT')
                <input type="hidden" id="edit_partner_id">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">الاسم <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="name" id="edit_name" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">كود المستخدم في نظام الفوترة</label>
                            <input type="text" class="form-control" name="user_code" id="edit_user_code"
                                   placeholder="مثال: ABC123">
                            <small class="text-muted">مخصص للربط مع نظام الفوترة</small>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">البريد الإلكتروني</label>
                            <input type="email" class="form-control" name="email" id="edit_email">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">رقم الهاتف</label>
                            <input type="text" class="form-control" name="phone" id="edit_phone">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">العنوان</label>
                            <input type="text" class="form-control" name="address" id="edit_address">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">النسبة المئوية <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="percentage" id="edit_percentage" step="0.01" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">رقم الهوية</label>
                            <input type="text" class="form-control" name="national_id" id="edit_national_id">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">اسم البنك</label>
                            <input type="text" class="form-control" name="bank_name" id="edit_bank_name">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">رقم الحساب</label>
                            <input type="text" class="form-control" name="bank_account" id="edit_bank_account">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">رقم الآيبان</label>
                            <input type="text" class="form-control" name="bank_iban" id="edit_bank_iban">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">ملاحظات</label>
                        <textarea class="form-control" name="notes" id="edit_notes" rows="3"></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">الحالة</label>
                        <select class="form-select" name="status" id="edit_status">
                            <option value="active">نشط</option>
                            <option value="inactive">غير نشط</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // عرض تفاصيل الشريك
    $('.view-partner').click(function() {
        const id = $(this).data('id');
        $.ajax({
            url: `/partners/${id}`,
            method: 'GET',
            success: function(partner) {
                $('#view_name').text(partner.name || '-');
                $('#view_user_code').text(partner.user_code || '-');
                $('#view_email').text(partner.email || '-');
                $('#view_phone').text(partner.phone || '-');
                $('#view_address').text(partner.address || '-');
                $('#view_national_id').text(partner.national_id || '-');
                $('#view_percentage').text((partner.percentage || 0) + '%');
                $('#view_bank_name').text(partner.bank_name || '-');
                $('#view_bank_account').text(partner.bank_account || '-');
                $('#view_bank_iban').text(partner.bank_iban || '-');
                $('#view_notes').text(partner.notes || '-');
                $('#viewPartnerModal').modal('show');
            },
            error: function(xhr) {
                showAlert('error', 'حدث خطأ أثناء تحميل بيانات الشريك');
            }
        });
    });

    // إضافة شريك جديد
    $('#addPartnerForm').on('submit', function(e) {
        e.preventDefault();
        
        $.ajax({
            url: '{{ route("partners.store") }}',
            method: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                $('#addPartnerModal').modal('hide');
                showAlert('success', response.message);
                setTimeout(() => location.reload(), 1500);
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || 'حدث خطأ أثناء إضافة الشريك';
                showAlert('error', message);
            }
        });
    });

    // تحميل بيانات الشريك للتعديل
    $('.edit-partner').click(function() {
        const id = $(this).data('id');
        $.ajax({
            url: `/partners/${id}`,
            method: 'GET',
            success: function(partner) {
                $('#edit_partner_id').val(partner.id);
                $('#edit_name').val(partner.name);
                $('#edit_user_code').val(partner.user_code);
                $('#edit_email').val(partner.email);
                $('#edit_phone').val(partner.phone);
                $('#edit_address').val(partner.address);
                $('#edit_percentage').val(partner.percentage);
                $('#edit_national_id').val(partner.national_id);
                $('#edit_bank_name').val(partner.bank_name);
                $('#edit_bank_account').val(partner.bank_account);
                $('#edit_bank_iban').val(partner.bank_iban);
                $('#edit_notes').val(partner.notes);
                $('#edit_status').val(partner.status);
                
                $('#editPartnerModal').modal('show');
            },
            error: function(xhr) {
                showAlert('error', 'حدث خطأ أثناء تحميل بيانات الشريك');
            }
        });
    });

    // معالجة تحديث الشريك
    $('#editPartnerForm').on('submit', function(e) {
        e.preventDefault();
        const id = $('#edit_partner_id').val();
        
        $.ajax({
            url: `/partners/${id}`,
            method: 'PUT',
            data: $(this).serialize(),
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                $('#editPartnerModal').modal('hide');
                showAlert('success', response.message);
                setTimeout(() => location.reload(), 1500);
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || 'حدث خطأ أثناء تحديث الشريك';
                showAlert('error', message);
            }
        });
    });

    // دالة مساعدة لعرض التنبيهات
    function showAlert(type, message) {
        const alertDiv = $('<div>')
            .addClass(`alert alert-${type} alert-dismissible fade show`)
            .attr('role', 'alert')
            .html(`
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `);

        $('.container').prepend(alertDiv);
        
        setTimeout(() => {
            alertDiv.alert('close');
        }, 3000);
    }

    // حذف شريك
    $('.delete-partner').click(function() {
        if (confirm('هل أنت متأكد من حذف هذا الشريك؟')) {
            const id = $(this).data('id');
            $.ajax({
                url: `/partners/${id}`,
                method: 'DELETE',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                success: function() {
                    location.reload();
                }
            });
        }
    });
});
</script>
@endpush
@endsection 