@extends('layouts.app')

@php
use App\Models\Setting;
@endphp

@section('content')
<div class="container">
    <div class="row mb-3">
        <div class="col">
            <h2 class="mb-0">فاتورة #{{ $invoice->id }}</h2>
        </div>
        <div class="col text-start">
            <a href="{{ route('invoices.index') }}" class="btn btn-secondary">
                <i class="bi bi-arrow-right"></i> عودة للفواتير
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5>معلومات البائع</h5>
                            <div class="mb-2">
                                <label class="fw-bold">الاسم:</label>
                                <div>{{ $invoice->seller_name ?: ($invoice->partner ? $invoice->partner->name : '-') }}</div>
                            </div>
                            @if($invoice->partner)
                            <div class="mb-2">
                                <label class="fw-bold">البريد الإلكتروني:</label>
                                <div>{{ $invoice->partner->email }}</div>
                            </div>
                            <div class="mb-2">
                                <label class="fw-bold">رقم الهاتف:</label>
                                <div>{{ $invoice->partner->phone }}</div>
                            </div>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <h5>معلومات المشتري</h5>
                            <div class="mb-2">
                                <label class="fw-bold">الاسم:</label>
                                <div>{{ $invoice->buyer_name }}</div>
                            </div>
                            <div class="mb-2">
                                <label class="fw-bold">رقم الهاتف:</label>
                                <div>{{ $invoice->buyer_phone }}</div>
                            </div>
                            <div class="mb-2">
                                <label class="fw-bold">العنوان:</label>
                                <div>{{ $invoice->buyer_address }}</div>
                            </div>
                            <div class="mb-2">
                                <label class="fw-bold">الرقم الضريبي:</label>
                                <div>{{ $invoice->buyer_tax_number }}</div>
                            </div>
                        </div>
                    </div>

                    <hr>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <h5>تفاصيل الفاتورة</h5>
                            <table class="table table-bordered mt-3">
                                <thead>
                                    <tr>
                                        <th>المنتج/الخدمة</th>
                                        <th>النسبة</th>
                                        <th>المبلغ الإجمالي</th>
                                        <th>حصة الشريك</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>{{ $invoice->transaction->category_info['name'] }}</td>
                                        <td>{{ number_format($invoice->share_percentage, 2) }}%</td>
                                        <td>{{ number_format($invoice->transaction->amount, 3) }} {{ Setting::get('currency', 'JOD') }}</td>
                                        <td>{{ number_format($invoice->amount, 3) }} {{ Setting::get('currency', 'JOD') }}</td>
                                    </tr>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="3" class="text-start"><strong>المجموع:</strong></td>
                                        <td><strong>{{ number_format($invoice->amount, 3) }} {{ Setting::get('currency', 'JOD') }}</strong></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-2">
                                <label class="fw-bold">تاريخ الفاتورة:</label>
                                <div>{{ $invoice->created_at->format('Y-m-d') }}</div>
                            </div>
                            <div class="mb-2">
                                <label class="fw-bold">حالة الفاتورة:</label>
                                <div>
                                    <span class="badge bg-{{ $invoice->status === 'paid' ? 'success' : ($invoice->status === 'cancelled' ? 'danger' : 'warning') }}">
                                        {{ $invoice->status === 'paid' ? 'مدفوعة' : ($invoice->status === 'cancelled' ? 'ملغاة' : 'معلقة') }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">الإجراءات</h5>
                </div>
                <div class="card-body">
                    @if($invoice->status === 'pending')
                        <button type="button" class="btn btn-success w-100 mb-2 update-status" data-id="{{ $invoice->id }}" data-status="paid">
                            <i class="bi bi-check-circle"></i> تأكيد الدفع
                        </button>
                        <button type="button" class="btn btn-danger w-100 update-status" data-id="{{ $invoice->id }}" data-status="cancelled">
                            <i class="bi bi-x-circle"></i> إلغاء الفاتورة
                        </button>
                    @endif
                </div>
            </div>

            @if($invoice->notes)
            <div class="card mt-3">
                <div class="card-header">
                    <h5 class="card-title mb-0">ملاحظات</h5>
                </div>
                <div class="card-body">
                    {{ $invoice->notes }}
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    $('.update-status').click(function() {
        const id = $(this).data('id');
        const status = $(this).data('status');
        
        Swal.fire({
            title: 'تأكيد التحديث',
            text: 'هل أنت متأكد من تحديث حالة الفاتورة؟',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'لا'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `/invoices/${id}/status`,
                    type: 'POST',
                    data: {
                        status: status,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function() {
                        location.reload();
                    }
                });
            }
        });
    });
});
</script>
@endpush
@endsection 