@extends('layouts.app')

@php
use App\Models\Setting;
@endphp

@section('content')
<div class="container">
    <h2 class="mb-4">فواتير الشركاء</h2>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>المعاملة</th>
                            <th>الشريك</th>
                            <th>المبلغ</th>
                            <th>النسبة</th>
                            <th>الحالة</th>
                            <th>التاريخ</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($invoices as $invoice)
                        <tr>
                            <td>{{ $invoice->id }}</td>
                            <td>{{ $invoice->transaction->description ?? 'معاملة #' . $invoice->transaction_id }}</td>
                            <td>
                                @if($invoice->partner)
                                    {{ $invoice->partner->name }}
                                @else
                                    {{ $invoice->seller_name ?: 'نظام إدارة الشركاء' }}
                                @endif
                            </td>
                            <td>{{ number_format($invoice->amount, 3) }} {{ Setting::get('currency', 'JOD') }}</td>
                            <td>{{ number_format($invoice->share_percentage, 2) }}%</td>
                            <td>
                                <span class="badge bg-{{ $invoice->status === 'paid' ? 'success' : ($invoice->status === 'cancelled' ? 'danger' : 'warning') }}">
                                    {{ $invoice->status === 'paid' ? 'مدفوعة' : ($invoice->status === 'cancelled' ? 'ملغاة' : 'معلقة') }}
                                </span>
                            </td>
                            <td>{{ $invoice->created_at->format('Y-m-d') }}</td>
                            <td>
                                <div class="btn-group">
                                    <a href="{{ route('invoices.show', $invoice) }}" class="btn btn-sm btn-info">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    @if($invoice->status === 'pending')
                                    <button type="button" class="btn btn-sm btn-success update-status" 
                                            data-id="{{ $invoice->id }}" data-status="paid">
                                        <i class="bi bi-check-lg"></i>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-danger update-status" 
                                            data-id="{{ $invoice->id }}" data-status="cancelled">
                                        <i class="bi bi-x-lg"></i>
                                    </button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{ $invoices->links() }}
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    $('.update-status').click(function() {
        const id = $(this).data('id');
        const status = $(this).data('status');
        
        Swal.fire({
            title: 'تأكيد التحديث',
            text: 'هل أنت متأكد من تحديث حالة الفاتورة؟',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'لا'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `/invoices/${id}/status`,
                    type: 'POST',
                    data: {
                        status: status,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function() {
                        location.reload();
                    }
                });
            }
        });
    });
});
</script>
@endpush
@endsection 