// تنسيق المبالغ
function formatCurrency(amount) {
    return new Intl.NumberFormat('en-US', {
        minimumFractionDigits: 3,
        maximumFractionDigits: 3
    }).format(amount) + ' JOD';
}

// تنسيق التواريخ
function formatDate(date) {
    return new Date(date).toLocaleDateString('en-US');
}

// التحقق من صحة النموذج
function validateForm(form) {
    let isValid = true;
    form.find('[required]').each(function() {
        if (!$(this).val()) {
            isValid = false;
            $(this).addClass('is-invalid');
        } else {
            $(this).removeClass('is-invalid');
        }
    });
    return isValid;
} 