<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run()
    {
        // إنشاء محاسب
        $accountant = User::create([
            'name' => 'محاسب النظام',
            'email' => 'accountant@example.com',
            'password' => Hash::make('password'),
            'email_verified_at' => now()
        ]);
        
        $accountant->addRole('accountant');

        // إنشاء مستخدم شريك
        $partner = User::create([
            'name' => 'شريك',
            'email' => 'partner@example.com',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'partner_id' => 1 // ربط مع أول شريك
        ]);

        $partner->addRole('partner');
    }
} 