<?php

namespace Database\Seeders;

use App\Models\Transaction;
use App\Models\Partner;
use Illuminate\Database\Seeder;

class TransactionSeeder extends Seeder
{
    public function run(): void
    {
        // نحصل على شريك عشوائي لربط المعاملات به
        $partner = Partner::inRandomOrder()->first();
        
        if (!$partner) {
            return; // لا نقوم بإنشاء معاملات إذا لم يكن هناك شركاء
        }

        $transactions = [
            [
                'partner_id' => $partner->id,
                'type' => 'income',
                'category' => 'مبيعات',
                'amount' => 50000,
                'description' => 'مبيعات شهر يناير',
                'transaction_date' => '2024-12-17',
            ],
            [
                'partner_id' => $partner->id,
                'type' => 'expense',
                'category' => 'رواتب',
                'amount' => 15000,
                'description' => 'رواتب شهر يناير',
                'transaction_date' => '2024-12-20',
            ],
            [
                'partner_id' => $partner->id,
                'type' => 'income',
                'category' => 'خدمات',
                'amount' => 25000,
                'description' => 'خدمات استشارية',
                'transaction_date' => '2024-12-25',
            ],
        ];

        foreach ($transactions as $transaction) {
            Transaction::create($transaction);
        }
    }
} 