<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingsSeeder extends Seeder
{
    public function run(): void
    {
        $settings = [
            [
                'key' => 'app_name',
                'value' => 'نظام إدارة الشركاء',
                'group' => 'general'
            ],
            [
                'key' => 'currency',
                'value' => 'JOD',
                'group' => 'general'
            ],
            [
                'key' => 'timezone',
                'value' => 'Asia/Amman',
                'group' => 'general'
            ],
            [
                'key' => 'footer_text',
                'value' => 'جميع الحقوق محفوظة © ' . date('Y'),
                'group' => 'general'
            ],
            [
                'key' => 'income_categories',
                'value' => json_encode(config('categories.income')),
                'group' => 'categories'
            ],
            [
                'key' => 'expense_categories',
                'value' => json_encode(config('categories.expense')),
                'group' => 'categories'
            ],
            [
                'key' => 'company_name',
                'value' => 'شركتي',
                'group' => 'company'
            ],
            [
                'key' => 'company_address',
                'value' => 'عمان - الأردن',
                'group' => 'company'
            ],
            [
                'key' => 'company_phone',
                'value' => '+962 XXXXXXXXX',
                'group' => 'company'
            ],
            [
                'key' => 'company_email',
                'value' => 'info@company.com',
                'group' => 'company'
            ]
        ];

        foreach ($settings as $setting) {
            Setting::create($setting);
        }
    }
} 