<?php

namespace Database\Seeders;

use App\Models\Role;
use App\Models\Permission;
use Illuminate\Database\Seeder;

class RolesAndPermissionsSeeder extends Seeder
{
    public function run()
    {
        // إنشاء الصلاحيات
        $permissions = [
            ['name' => 'partners-list', 'display_name' => 'عرض الشركاء'],
            ['name' => 'partners-create', 'display_name' => 'إضافة شريك'],
            ['name' => 'partners-edit', 'display_name' => 'تعديل شريك'],
            ['name' => 'partners-delete', 'display_name' => 'حذف شريك'],
            
            ['name' => 'transactions-list', 'display_name' => 'عرض المعاملات'],
            ['name' => 'transactions-create', 'display_name' => 'إضافة معاملة'],
            ['name' => 'transactions-edit', 'display_name' => 'تعديل معاملة'],
            ['name' => 'transactions-delete', 'display_name' => 'حذف معاملة'],
            
            ['name' => 'reports-list', 'display_name' => 'عرض التقارير'],
            ['name' => 'reports-export', 'display_name' => 'تصدير التقارير'],
        ];

        foreach ($permissions as $permission) {
            Permission::create($permission);
        }

        // إنشاء الأدوار
        $roles = [
            [
                'name' => 'admin',
                'display_name' => 'مدير النظام',
                'permissions' => Permission::all()->pluck('name')->toArray()
            ],
            [
                'name' => 'accountant',
                'display_name' => 'محاسب',
                'permissions' => [
                    'transactions-list',
                    'transactions-create',
                    'transactions-edit',
                    'reports-list',
                    'reports-export'
                ]
            ],
            [
                'name' => 'partner',
                'display_name' => 'شريك',
                'permissions' => [
                    'reports-list'
                ]
            ]
        ];

        foreach ($roles as $roleData) {
            $permissions = $roleData['permissions'];
            unset($roleData['permissions']);
            
            $role = Role::create($roleData);
            $role->syncPermissions($permissions);
        }
    }
} 