<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('partners', function (Blueprint $table) {
            $table->string('national_id')->nullable()->after('address');
            $table->string('bank_name')->nullable()->after('national_id');
            $table->string('bank_account')->nullable()->after('bank_name');
            $table->string('bank_iban')->nullable()->after('bank_account');
            $table->text('notes')->nullable()->after('bank_iban');
        });
    }

    public function down()
    {
        Schema::table('partners', function (Blueprint $table) {
            $table->dropColumn([
                'national_id',
                'bank_name',
                'bank_account',
                'bank_iban',
                'notes'
            ]);
        });
    }
}; 