<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        Schema::table('partners', function (Blueprint $table) {
            if (!Schema::hasColumn('partners', 'status')) {
                $table->string('status')->default('active')->after('is_active');
            }
        });

        DB::table('partners')
            ->where('is_active', true)
            ->update(['status' => 'active']);

        DB::table('partners')
            ->where('is_active', false)
            ->update(['status' => 'inactive']);
    }

    public function down()
    {
        Schema::table('partners', function (Blueprint $table) {
            $table->dropColumn('status');
        });
    }
}; 