<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Setting;

class Transaction extends Model
{
    protected $fillable = [
        'partner_id',
        'type',
        'category',
        'amount',
        'description',
        'transaction_date',
        'buyer_name',
        'buyer_phone',
        'buyer_address',
        'buyer_tax_number'
    ];

    protected $casts = [
        'transaction_date' => 'date',
        'amount' => 'decimal:2'
    ];

    protected $appends = [
        'category_info'
    ];

    public function partner()
    {
        return $this->belongsTo(Partner::class);
    }

    public function getCategoryInfoAttribute()
    {
        $categories = $this->type === 'income' 
            ? json_decode(Setting::get('income_categories'), true) 
            : json_decode(Setting::get('expense_categories'), true);

        return $categories[$this->category] ?? [
            'name' => $this->category,
            'icon' => 'bi bi-circle',
            'color' => '#6c757d'
        ];
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }
} 