<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Partner extends Model
{
    protected $fillable = [
        'name',
        'user_code',
        'email',
        'phone',
        'address',
        'percentage',
        'status',
        'national_id',
        'bank_name',
        'bank_account',
        'bank_iban',
        'notes'
    ];

    protected $casts = [
        'percentage' => 'decimal:2',
        'is_active' => 'boolean'
    ];

    public function transactions()
    {
        return $this->hasMany(Transaction::class);
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function getShareAmount($amount)
    {
        return ($amount * $this->percentage) / 100;
    }
} 