<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    protected $fillable = [
        'transaction_id',
        'partner_id',
        'seller_name',
        'amount',
        'share_percentage',
        'status',
        'buyer_name',
        'buyer_phone',
        'buyer_address',
        'buyer_tax_number'
    ];

    public function transaction()
    {
        return $this->belongsTo(Transaction::class);
    }

    public function partner()
    {
        return $this->belongsTo(Partner::class);
    }
} 