<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckRole
{
    protected $routePermissions = [
        'partners.index' => 'partners.view',
        'partners.store' => 'partners.create',
        'partners.update' => 'partners.edit',
        'partners.destroy' => 'partners.delete',
        
        'transactions.index' => 'transactions.view',
        'transactions.store' => 'transactions.create',
        'transactions.update' => 'transactions.edit',
        'transactions.destroy' => 'transactions.delete',
        
        'reports.index' => 'reports.view',
        'reports.export' => 'reports.export'
    ];

    public function handle(Request $request, Closure $next, ...$roles)
    {
        $user = $request->user();
        
        if (!$user) {
            return redirect('login');
        }

        // التحقق من الدور
        if (!empty($roles) && !$user->hasAnyRole($roles)) {
            abort(403, 'غير مصرح لك بالوصول إلى هذه الصفحة');
        }

        // التحقق من الصلاحيات
        $routeName = $request->route()->getName();
        
        if (isset($this->routePermissions[$routeName])) {
            $permission = $this->routePermissions[$routeName];
            
            if (!$user->hasPermissionTo($permission)) {
                abort(403, 'ليس لديك الصلاحيات الكافية للقيام بهذا الإجراء');
            }
        }

        return $next($request);
    }
} 