<?php

namespace App\Http\Controllers;

use App\Models\Invoice;
use App\Models\Transaction;
use Illuminate\Http\Request;

class InvoiceController extends Controller
{
    public function index()
    {
        $invoices = Invoice::with(['transaction', 'partner'])
            ->latest()
            ->paginate(10);

        return view('invoices.index', compact('invoices'));
    }

    public function show(Invoice $invoice)
    {
        return view('invoices.show', compact('invoice'));
    }

    public function updateStatus(Invoice $invoice, Request $request)
    {
        $request->validate([
            'status' => 'required|in:pending,paid,cancelled'
        ]);

        $invoice->update([
            'status' => $request->status,
            'notes' => $request->notes
        ]);

        return back()->with('success', 'تم تحديث حالة الفاتورة بنجاح');
    }
} 